
#ifndef _PROS_MAIN_H_
#define _PROS_MAIN_H_

#define PROS_USE_SIMPLE_NAMES

#define PROS_USE_LITERALS

#include "api.h"

/**
 * You should add more #includes here
 */

#include "okapi\api.hpp"
//#include "pros/api_legacy.h"
//#include "pros/apix.h"

/**
 * If you find doing pros::Motor() to be tedious and you'd prefer just to do
 * Motor, you can use the namespace with the following commented out line.
 *
 * IMPORTANT: Only the okapi or pros namespace may be used, not both
 * concurrently! The okapi namespace will export all symbols inside the pros
 * namespace.
 */
 using namespace pros;
 using namespace pros::literals;
 using namespace okapi;

/**
 * Prototypes for the competition control tasks are redefined here to ensure
 * that they can be called from user code (i.e. calling autonomous from a
 * button press in opcontrol() for testing purposes).
 */
#ifdef __cplusplus
extern "C" {
#endif
void autonomous(void);
void initialize(void);
void disabled(void);
void competition_initialize(void);
void opcontrol(void);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
/**
 * You can add C++-only headers here
 */
#include <iostream>
#endif

#endif  // _PROS_MAIN_H_

std::shared_ptr<OdomChassisController> odomChassis;
okapi::Controller controller;

pros::ADIDigitalOut clamp('H');
pros::ADIDigitalOut doinker('G');
okapi::MotorGroup intake ({-10});
okapi::MotorGroup stage2 ({11});
pros::Rotation LBRotation ({9});
okapi::MotorGroup ladyBrown ({2});
okapi::OpticalSensor opticalSensor(5);