/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.difficulty;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.defaultoptions.config.DefaultOptionsConfig;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.world.Difficulty;

public class DefaultDifficultyHandler {
    private static final Set<Integer> touchedScreens = new HashSet<Integer>();

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, DefaultDifficultyHandler::onInitGui);
    }

    public static void onInitGui(ScreenInitEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            WorldCreationUiState uiState = screen2.getUiState();
            if (!touchedScreens.contains(screen2.hashCode())) {
                Difficulty difficulty = DefaultOptionsConfig.getActive().defaultDifficulty.toDifficulty();
                uiState.setDifficulty(difficulty);
                touchedScreens.add(screen2.hashCode());
            }
            if (DefaultOptionsConfig.getActive().lockDifficulty) {
                DefaultDifficultyHandler.lockDifficultyButton(screen2);
            }
            uiState.addListener(state -> {
                if (DefaultOptionsConfig.getActive().lockDifficulty) {
                    DefaultDifficultyHandler.lockDifficultyButton(screen2);
                }
            });
        }
    }

    private static void lockDifficultyButton(CreateWorldScreen screen) {
        AbstractWidget difficultyButton = DefaultDifficultyHandler.findDifficultyButton(screen);
        if (difficultyButton != null) {
            difficultyButton.active = false;
        }
    }

    private static AbstractWidget findDifficultyButton(CreateWorldScreen screen) {
        return screen.children().stream().filter(it -> {
            CycleButton button;
            return it instanceof CycleButton && (button = (CycleButton)it).getValue() instanceof Difficulty;
        }).findAny().orElse(null);
    }
}

