/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.entity;

import mod.crend.dynamiccrosshair.mixin.entity.TameableEntityMixin;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Wolf.class})
public abstract class WolfEntityMixin
extends TameableEntityMixin
implements DynamicCrosshairEntity {
    @Shadow
    public abstract DyeColor getCollarColor();

    @Shadow
    public abstract boolean hasArmor();

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        if (this.isTame() && this.isOwnedBy((LivingEntity)context.getPlayer())) {
            Item item = context.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (this.getCollarColor() != dye.getDyeColor()) {
                    return InteractionType.USE_ITEM_ON_ENTITY;
                }
            }
            if (context.getItem() == Items.WOLF_ARMOR && !this.hasArmor() && !this.isBaby()) {
                return InteractionType.PLACE_ITEM_ON_ENTITY;
            }
            if (context.getItem() == Items.SHEARS && this.hasArmor()) {
                return InteractionType.TAKE_ITEM_FROM_ENTITY;
            }
            return InteractionType.INTERACT_WITH_ENTITY;
        }
        return super.dynamiccrosshair$compute(context);
    }
}

