/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.impl;

import java.util.List;
import java.util.function.Function;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshair.impl.ApiList;
import mod.crend.dynamiccrosshair.impl.ContextedApiImpl;
import mod.crend.dynamiccrosshair.mixin.BlockItemAccessor;
import mod.crend.dynamiccrosshair.mixin.ItemAccessor;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.exception.CrosshairContextChange;
import mod.crend.dynamiccrosshairapi.exception.InvalidContextState;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrosshairContextImpl
implements CrosshairContext {
    @NotNull
    public ClientLevel world;
    @NotNull
    public final LocalPlayer player;
    @NotNull
    public HitResult hitResult;
    private final ContextedApiImpl api;
    private boolean withBlock = false;
    private BlockPos blockPos = null;
    private BlockState blockState = null;
    private BlockEntity blockEntity = null;
    private boolean withEntity = false;
    private Entity entity = null;
    private InteractionHand hand;
    private ItemStack itemStackMainHand = null;
    private ItemStack itemStackOffHand = null;
    private ApiList apiList = null;

    public CrosshairContextImpl() {
        assert (Minecraft.getInstance().level != null);
        assert (Minecraft.getInstance().player != null);
        assert (Minecraft.getInstance().hitResult != null);
        this.world = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        this.hand = InteractionHand.MAIN_HAND;
        this.hitResult = Minecraft.getInstance().hitResult;
        this.api = new ContextedApiImpl(this);
        this.invalidateHitResult(this.hitResult);
    }

    @NotNull
    public ClientLevel getWorld() {
        return this.world;
    }

    @NotNull
    public LocalPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public HitResult getHitResult() {
        return this.hitResult;
    }

    public void invalidateHitResult(HitResult newHitResult) {
        assert (newHitResult != null);
        assert (Minecraft.getInstance().level != null);
        this.hitResult = newHitResult;
        this.withBlock = false;
        this.blockPos = null;
        this.blockState = null;
        this.blockEntity = null;
        this.withEntity = false;
        this.entity = null;
        this.apiList = null;
        this.itemStackMainHand = null;
        this.itemStackOffHand = null;
        switch (this.hitResult.getType()) {
            case BLOCK: {
                BlockHitResult blockHitResult = (BlockHitResult)this.hitResult;
                this.withBlock = true;
                this.blockPos = blockHitResult.getBlockPos();
                break;
            }
            case ENTITY: {
                EntityHitResult entityHitResult = (EntityHitResult)this.hitResult;
                this.withEntity = true;
                this.entity = entityHitResult.getEntity();
            }
        }
        this.world = Minecraft.getInstance().level;
        for (DynamicCrosshairApi api : this.apis()) {
            try {
                ClientLevel useWorld = api.overrideWorld();
                if (useWorld == null) continue;
                this.world = useWorld;
                break;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException throwable) {
            }
        }
    }

    public void invalidateItem(InteractionHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                this.itemStackMainHand = null;
                break;
            }
            case OFF_HAND: {
                this.itemStackOffHand = null;
            }
        }
    }

    public boolean isTargeting() {
        return this.hitResult.getType() != HitResult.Type.MISS;
    }

    public boolean isEmptyHanded() {
        return this.player.getMainHandItem().isEmpty() && this.player.getOffhandItem().isEmpty();
    }

    public boolean shouldInteract() {
        return !this.player.isSecondaryUseActive() || this.isEmptyHanded();
    }

    public boolean isFlying() {
        return this.player.isFallFlying();
    }

    public boolean isWithBlock() {
        return this.withBlock;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockState(): blockPos is null despite targeted block!");
        }
        if (this.blockState == null) {
            this.blockState = this.world.getBlockState(this.blockPos);
        }
        return this.blockState;
    }

    public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    public BlockEntity getBlockEntity() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockEntity() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockEntity(): blockPos is null despite targeted block!");
        }
        if (this.blockEntity == null) {
            this.blockEntity = this.world.getBlockEntity(this.blockPos);
        }
        return this.blockEntity;
    }

    public FluidState getFluidState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getFluidState(): blockPos is null despite targeted block!");
        }
        return this.world.getFluidState(this.blockPos);
    }

    public BlockHitResult getBlockHitResult() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        return (BlockHitResult)this.hitResult;
    }

    public Direction getBlockHitSide() {
        return this.getBlockHitResult().getDirection();
    }

    public BlockHitResult raycastWithFluid(ClipContext.Fluid fluidHandling) {
        return ItemAccessor.invokeGetPlayerPOVHitResult((Level)this.world, (Player)this.player, fluidHandling);
    }

    public BlockHitResult raycastWithFluid() {
        return this.raycastWithFluid(ClipContext.Fluid.ANY);
    }

    public EntityHitResult raycastForEntity(double d) {
        Vec3 vCamPos = this.player.getEyePosition(1.0f);
        Vec3 vRotation = this.player.getViewVector(1.0f);
        Vec3 vRaycast = vCamPos.add(vRotation.x * d, vRotation.y * d, vRotation.z * d);
        AABB box = this.player.getBoundingBox().expandTowards(vRotation.scale(d)).inflate(1.0, 1.0, 1.0);
        return ProjectileUtil.getEntityHitResult((Entity)this.player, (Vec3)vCamPos, (Vec3)vRaycast, (AABB)box, entity -> !entity.isSpectator() && entity.canBeCollidedWith(), (double)(d * d));
    }

    public boolean isWithEntity() {
        return this.withEntity;
    }

    public Entity getEntity() {
        if (!this.withEntity) {
            throw new InvalidContextState("Called getEntity() without a targeted entity!");
        }
        if (this.entity == null) {
            throw new InvalidContextState("In getEntity(): entity is null despite targeted entity!");
        }
        return this.entity;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void setHand(InteractionHand hand) {
        this.hand = hand;
    }

    public boolean isMainHand() {
        return this.hand == InteractionHand.MAIN_HAND;
    }

    public boolean isOffHand() {
        return this.hand == InteractionHand.OFF_HAND;
    }

    public ItemStack getItemStack(InteractionHand hand) {
        ItemStack itemStack;
        switch (hand) {
            default: {
                throw new MatchException(null, null);
            }
            case MAIN_HAND: {
                ItemStack itemStack2 = this.itemStackMainHand;
                break;
            }
            case OFF_HAND: {
                ItemStack itemStack2 = itemStack = this.itemStackOffHand;
            }
        }
        if (itemStack == null) {
            itemStack = this.player.getItemInHand(hand);
            switch (hand) {
                case MAIN_HAND: {
                    this.itemStackMainHand = itemStack;
                    break;
                }
                case OFF_HAND: {
                    this.itemStackOffHand = itemStack;
                }
            }
        }
        return itemStack;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.hand);
    }

    public Item getItem() {
        return this.getItemStack().getItem();
    }

    public boolean isActiveItem() {
        return this.player.getUseItem().equals(this.getItemStack());
    }

    public boolean isCoolingDown() {
        return this.player.getCooldowns().isOnCooldown(this.getItem());
    }

    public boolean canPlaceItemAsBlock() {
        if (!this.withBlock) {
            return false;
        }
        if (!(this.getItem() instanceof BlockItem)) {
            return true;
        }
        BlockItemAccessor blockItem = (BlockItemAccessor)this.getItem();
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext((Player)this.player, this.hand, this.getItemStack(), (BlockHitResult)this.hitResult);
        try {
            BlockState blockState = blockItem.invokeGetPlacementState(itemPlacementContext);
            return blockState != null && blockItem.invokeCanPlace(itemPlacementContext, blockState);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean canUseWeaponAsTool() {
        return this.isWithBlock() && DynamicCrosshairMod.config.dynamicCrosshairHoldingTool() != CrosshairPolicy.Disabled;
    }

    public boolean includeUsableItem() {
        return switch (DynamicCrosshairMod.config.dynamicCrosshairHoldingUsableItem()) {
            default -> throw new MatchException(null, null);
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeThrowable() {
        return switch (DynamicCrosshairMod.config.dynamicCrosshairHoldingThrowable()) {
            default -> throw new MatchException(null, null);
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeRangedWeapon() {
        return DynamicCrosshairMod.config.dynamicCrosshairHoldingRangedWeapon() != UsableCrosshairPolicy.Disabled;
    }

    public boolean includeMeleeWeapon() {
        return this.isMainHand() && DynamicCrosshairMod.config.dynamicCrosshairHoldingMeleeWeapon();
    }

    public boolean includeTool() {
        boolean bl;
        block7: {
            block6: {
                if (!this.isMainHand()) break block6;
                switch (DynamicCrosshairMod.config.dynamicCrosshairHoldingTool()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case Always: {
                        break;
                    }
                    case IfTargeting: {
                        if (this.isTargeting()) {
                            break;
                        }
                        break block6;
                    }
                    case Disabled: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public boolean includeShield() {
        return DynamicCrosshairMod.config.dynamicCrosshairHoldingShield() && !this.isCoolingDown();
    }

    public boolean includeHoldingBlock() {
        if (this.isOffHand() && !DynamicCrosshairMod.config.dynamicCrosshairHoldingBlockInOffhand()) {
            return false;
        }
        return switch (DynamicCrosshairMod.config.dynamicCrosshairHoldingBlock()) {
            default -> throw new MatchException(null, null);
            case BlockCrosshairPolicy.Always -> true;
            case BlockCrosshairPolicy.IfTargeting -> this.isTargeting();
            case BlockCrosshairPolicy.IfInteractable -> this.canPlaceItemAsBlock();
            case BlockCrosshairPolicy.Disabled -> false;
        };
    }

    public List<DynamicCrosshairApi> apis() {
        if (this.apiList == null) {
            this.apiList = new ApiList();
            this.apiList.add(this.getItemStack(InteractionHand.MAIN_HAND));
            this.apiList.add(this.getItemStack(InteractionHand.OFF_HAND));
            if (this.isWithBlock()) {
                this.apiList.add(this.getBlockState());
            }
            if (this.isWithEntity()) {
                this.apiList.add(this.getEntity());
            }
        }
        return this.apiList.get();
    }

    public ContextedApiImpl api() {
        return this.api;
    }

    @Nullable
    public <R> R withApisUntilNonNull(Function<DynamicCrosshairApi, R> lambda) {
        for (DynamicCrosshairApi api : this.apis()) {
            try {
                R result = lambda.apply(api);
                if (result == null) continue;
                return result;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                if (e instanceof CrosshairContextChange) {
                    throw e;
                }
                CrosshairHandler.LOGGER.error("Exception occurred during evaluation of API {}", (Object)api.getModId(), (Object)e);
            }
        }
        return null;
    }

    public InteractionType checkToolWithBlock() {
        if (!this.isWithBlock()) {
            return InteractionType.EMPTY;
        }
        BlockState blockState = this.getBlockState();
        ItemStack handItemStack = this.getItemStack();
        Item handItem = this.getItem();
        if (handItem instanceof DiggerItem) {
            if (handItemStack.isCorrectToolForDrops(blockState) && handItem.canAttackBlock(blockState, (Level)this.getWorld(), this.blockPos, (Player)this.getPlayer())) {
                return InteractionType.CORRECT_TOOL;
            }
            return InteractionType.INCORRECT_TOOL;
        }
        if (handItemStack.getDestroySpeed(blockState) > 1.0f && handItem.canAttackBlock(blockState, (Level)this.getWorld(), this.blockPos, (Player)this.getPlayer())) {
            return InteractionType.CORRECT_TOOL;
        }
        if (handItem instanceof ShearsItem) {
            return InteractionType.INCORRECT_TOOL;
        }
        return InteractionType.EMPTY;
    }
}

