/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.item.custom.BlankTmItem;
import dragomordor.simpletms.item.custom.MoveLearnItem;
import dragomordor.simpletms.util.MiscUtilsKt;
import dragomordor.simpletms.util.MoveLearnItemDefinition;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0014J%\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0012\u00a2\u0006\u0004\b#\u0010\u0003J\u0015\u0010%\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\u00020'2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010/\u001a\u00020\u00062\u0006\u0010+\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u00100R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020'018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0014\u00107\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108R\u0014\u0010:\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00108R\u0014\u0010;\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00108R\u0014\u0010<\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u00108R\u001d\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\u001d\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006\u00a2\u0006\f\n\u0004\bA\u0010>\u001a\u0004\bB\u0010@R\u001d\u0010C\u001a\b\u0012\u0004\u0012\u00020.0\u00188\u0006\u00a2\u0006\f\n\u0004\bC\u0010>\u001a\u0004\bD\u0010@R\u001d\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188\u0006\u00a2\u0006\f\n\u0004\bE\u0010>\u001a\u0004\bF\u0010@R\u001d\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006\u00a2\u0006\f\n\u0004\bG\u0010>\u001a\u0004\bH\u0010@R\u001d\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006\u00a2\u0006\f\n\u0004\bI\u0010>\u001a\u0004\bJ\u0010@R\u001d\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8\u0006\u00a2\u0006\f\n\u0004\bK\u0010>\u001a\u0004\bL\u0010@R#\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u001f8\u0006\u00a2\u0006\f\n\u0004\bM\u0010>\u001a\u0004\bN\u0010@R#\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u001f8\u0006\u00a2\u0006\f\n\u0004\bO\u0010>\u001a\u0004\bP\u0010@R\u001d\u0010Q\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010TR\u001d\u0010U\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\bU\u0010R\u001a\u0004\bV\u0010T\u00a8\u0006W"}, d2={"Ldragomordor/simpletms/SimpleTMsItems;", "", "<init>", "()V", "", "name", "", "isTR", "Ldev/architectury/registry/registries/RegistrySupplier;", "Ldragomordor/simpletms/item/custom/BlankTmItem;", "registerBlankTmItem", "(Ljava/lang/String;Z)Ldev/architectury/registry/registries/RegistrySupplier;", "moveName", "Ldragomordor/simpletms/item/custom/MoveLearnItem;", "registerMoveLearnItem", "(Ljava/lang/String;Ljava/lang/String;Z)Ldev/architectury/registry/registries/RegistrySupplier;", "Ljava/io/File;", "moveFile", "", "registerMoveLearnItemsFromConfig", "(Ljava/io/File;Z)V", "jsonFilePath", "registerMoveLearnItemsFromResourceJSON", "(Ljava/lang/String;)V", "", "Ldragomordor/simpletms/util/MoveLearnItemDefinition;", "loadMoveLearnItemsFromJson", "(Ljava/lang/String;)Ljava/util/List;", "moveConfigFile", "loadDefaultMoveConfig", "excludedMovesFile", "", "excludedMoveList", "loadExcludedMovesFromConfig", "(Ljava/io/File;Ljava/util/List;)V", "registerModItems", "Lnet/minecraft/world/item/ItemStack;", "getItemStackFromName", "(Ljava/lang/String;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item;", "getItemFromName", "(Ljava/lang/String;)Lnet/minecraft/world/item/Item;", "Lcom/cobblemon/mod/common/api/moves/Move;", "move", "getTMorTRItemFromMove", "(Lcom/cobblemon/mod/common/api/moves/Move;Z)Lnet/minecraft/world/item/Item;", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "hasItemForMove", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;Z)Z", "Ldev/architectury/registry/registries/DeferredRegister;", "ITEMS", "Ldev/architectury/registry/registries/DeferredRegister;", "DEFAULT_MOVE_JSON_PATH", "Ljava/lang/String;", "MOVE_ASSOCIATION_PATH", "defaultTMMoveConfigFile", "Ljava/io/File;", "defaultTRMoveConfigFile", "movesExcludedFromPokemonDropsFile", "moveExcludedFromBlankLearningFile", "movesExcludedFromTMTRLearningFile", "ALL_MOVE_NAMES_WITH_TM_ITEMS", "Ljava/util/List;", "getALL_MOVE_NAMES_WITH_TM_ITEMS", "()Ljava/util/List;", "ALL_MOVE_NAMES_WITH_TR_ITEMS", "getALL_MOVE_NAMES_WITH_TR_ITEMS", "ALL_MOVE_TEMPLATES_WITH_ITEMS", "getALL_MOVE_TEMPLATES_WITH_ITEMS", "ALL_REMOVED_DEFAULT_MOVES", "getALL_REMOVED_DEFAULT_MOVES", "ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS", "getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS", "ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING", "getALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING", "ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING", "getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING", "TM_ITEMS", "getTM_ITEMS", "TR_ITEMS", "getTR_ITEMS", "BLANK_TM", "Ldev/architectury/registry/registries/RegistrySupplier;", "getBLANK_TM", "()Ldev/architectury/registry/registries/RegistrySupplier;", "BLANK_TR", "getBLANK_TR", "common"})
@SourceDebugExtension(value={"SMAP\nSimpleTMsItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTMsItems.kt\ndragomordor/simpletms/SimpleTMsItems\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,290:1\n1#2:291\n96#3:292\n96#3:293\n96#3:294\n*S KotlinDebug\n*F\n+ 1 SimpleTMsItems.kt\ndragomordor/simpletms/SimpleTMsItems\n*L\n120#1:292\n159#1:293\n200#1:294\n*E\n"})
public final class SimpleTMsItems {
    @NotNull
    public static final SimpleTMsItems INSTANCE = new SimpleTMsItems();
    @NotNull
    private static final DeferredRegister<Item> ITEMS;
    @NotNull
    private static final String DEFAULT_MOVE_JSON_PATH = "simpletms/movelearnitems/default.json";
    @NotNull
    private static final String MOVE_ASSOCIATION_PATH = "simpletms/movelearnitems/move_associations.json";
    @NotNull
    private static final File defaultTMMoveConfigFile;
    @NotNull
    private static final File defaultTRMoveConfigFile;
    @NotNull
    private static final File movesExcludedFromPokemonDropsFile;
    @NotNull
    private static final File moveExcludedFromBlankLearningFile;
    @NotNull
    private static final File movesExcludedFromTMTRLearningFile;
    @NotNull
    private static final List<String> ALL_MOVE_NAMES_WITH_TM_ITEMS;
    @NotNull
    private static final List<String> ALL_MOVE_NAMES_WITH_TR_ITEMS;
    @NotNull
    private static final List<MoveTemplate> ALL_MOVE_TEMPLATES_WITH_ITEMS;
    @NotNull
    private static final List<String> ALL_REMOVED_DEFAULT_MOVES;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> TM_ITEMS;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> TR_ITEMS;
    @NotNull
    private static final RegistrySupplier<BlankTmItem> BLANK_TM;
    @NotNull
    private static final RegistrySupplier<BlankTmItem> BLANK_TR;

    private SimpleTMsItems() {
    }

    @NotNull
    public final List<String> getALL_MOVE_NAMES_WITH_TM_ITEMS() {
        return ALL_MOVE_NAMES_WITH_TM_ITEMS;
    }

    @NotNull
    public final List<String> getALL_MOVE_NAMES_WITH_TR_ITEMS() {
        return ALL_MOVE_NAMES_WITH_TR_ITEMS;
    }

    @NotNull
    public final List<MoveTemplate> getALL_MOVE_TEMPLATES_WITH_ITEMS() {
        return ALL_MOVE_TEMPLATES_WITH_ITEMS;
    }

    @NotNull
    public final List<String> getALL_REMOVED_DEFAULT_MOVES() {
        return ALL_REMOVED_DEFAULT_MOVES;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS() {
        return ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING() {
        return ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING() {
        return ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getTM_ITEMS() {
        return TM_ITEMS;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getTR_ITEMS() {
        return TR_ITEMS;
    }

    @NotNull
    public final RegistrySupplier<BlankTmItem> getBLANK_TM() {
        return BLANK_TM;
    }

    @NotNull
    public final RegistrySupplier<BlankTmItem> getBLANK_TR() {
        return BLANK_TR;
    }

    private final RegistrySupplier<BlankTmItem> registerBlankTmItem(String name, boolean isTR) {
        Item.Properties settings = null;
        if (isTR) {
            settings = new Item.Properties().stacksTo(SimpleTMs.INSTANCE.getConfig().getTrStackSize());
            if (SimpleTMs.INSTANCE.getConfig().getBlankTRBaseDurability() > 0) {
                settings.durability(SimpleTMs.INSTANCE.getConfig().getBlankTRBaseDurability());
            }
        } else {
            settings = new Item.Properties().stacksTo(1);
            if (SimpleTMs.INSTANCE.getConfig().getBlankTMBaseDurability() > 0) {
                settings.durability(SimpleTMs.INSTANCE.getConfig().getBlankTMBaseDurability());
            }
        }
        RegistrySupplier item = ITEMS.register(name, () -> SimpleTMsItems.registerBlankTmItem$lambda$0(isTR, settings));
        Intrinsics.checkNotNull((Object)item);
        return item;
    }

    private final RegistrySupplier<MoveLearnItem> registerMoveLearnItem(String name, String moveName, boolean isTR) {
        RegistrySupplier item = null;
        if (isTR) {
            Item.Properties properties = new Item.Properties().stacksTo(SimpleTMs.INSTANCE.getConfig().getTrStackSize());
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
            Item.Properties settings = properties;
            item = ITEMS.register(name, () -> SimpleTMsItems.registerMoveLearnItem$lambda$1(moveName, isTR, settings));
            TR_ITEMS.add((RegistrySupplier<MoveLearnItem>)item);
            v1 = ALL_MOVE_NAMES_WITH_TR_ITEMS.add(moveName);
        } else {
            Item.Properties properties = new Item.Properties().stacksTo(1);
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
            Item.Properties settings = properties;
            if (SimpleTMs.INSTANCE.getConfig().getTmBaseDurability() > 0) {
                settings.durability(SimpleTMs.INSTANCE.getConfig().getTmBaseDurability());
            }
            item = ITEMS.register(name, () -> SimpleTMsItems.registerMoveLearnItem$lambda$2(moveName, isTR, settings));
            TM_ITEMS.add((RegistrySupplier<MoveLearnItem>)item);
            v1 = ALL_MOVE_NAMES_WITH_TM_ITEMS.add(moveName);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerMoveLearnItemsFromConfig(File moveFile, boolean isTR) {
        Closeable closeable = new FileReader(moveFile);
        Throwable throwable = null;
        try {
            Object it = (FileReader)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonContent = it;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List itemDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
        String prefixString = isTR ? "tr_" : "tm_";
        for (MoveLearnItemDefinition itemDefinition : itemDefinitions) {
            this.registerMoveLearnItem(prefixString + itemDefinition.getMoveName(), itemDefinition.getMoveName(), isTR);
        }
    }

    private final void registerMoveLearnItemsFromResourceJSON(String jsonFilePath) {
        List<MoveLearnItemDefinition> itemDefinitions = this.loadMoveLearnItemsFromJson(jsonFilePath);
        for (MoveLearnItemDefinition itemDefinition : itemDefinitions) {
            this.registerMoveLearnItem("tm_" + itemDefinition.getMoveName(), itemDefinition.getMoveName(), false);
        }
        for (MoveLearnItemDefinition itemDefinition : itemDefinitions) {
            this.registerMoveLearnItem("tr_" + itemDefinition.getMoveName(), itemDefinition.getMoveName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<MoveLearnItemDefinition> loadMoveLearnItemsFromJson(String jsonFilePath) {
        InputStream inputStream = SimpleTMs.class.getResourceAsStream("/" + jsonFilePath);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + jsonFilePath);
        }
        InputStream resourceStream = inputStream;
        Closeable closeable = new InputStreamReader(resourceStream);
        Throwable throwable = null;
        try {
            Object it = (InputStreamReader)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonContent = it;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List itemDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
        return itemDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadDefaultMoveConfig(File moveConfigFile, boolean isTR) {
        String nameString;
        moveConfigFile.getParentFile().mkdirs();
        String string = nameString = isTR ? "TR" : "TM";
        if (moveConfigFile.exists()) {
            SimpleTMs.LOGGER.info("Found default moves config file for SimpleTMs for " + nameString + " moves");
        } else {
            String string2;
            SimpleTMs.LOGGER.info("Default moves config file not found. Creating default moves config file");
            InputStream inputStream = SimpleTMs.class.getResourceAsStream("/simpletms/movelearnitems/default.json");
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: simpletms/movelearnitems/default.json");
            }
            InputStream resourceStream = inputStream;
            Closeable closeable = new InputStreamReader(resourceStream);
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                string2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String jsonContent = string2;
            try {
                FileWriter fileWriter = new FileWriter(moveConfigFile);
                fileWriter.write(jsonContent);
                fileWriter.close();
            }
            catch (Exception exception) {
                SimpleTMs.LOGGER.error("Failed to save config file for simpletms. Reason:");
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadExcludedMovesFromConfig(File excludedMovesFile, List<String> excludedMoveList) {
        excludedMovesFile.getParentFile().mkdirs();
        if (excludedMovesFile.exists()) {
            SimpleTMs.LOGGER.info("Found excluded moves config file for SimpleTMs");
            Closeable closeable = new FileReader(excludedMovesFile);
            Object object = null;
            try {
                Object it = (FileReader)closeable;
                boolean bl = false;
                it = TextStreamsKt.readText((Reader)((Reader)it));
            }
            catch (Throwable it) {
                object = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object jsonContent = it;
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List moveDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
            excludedMoveList.clear();
            for (MoveLearnItemDefinition moveDefinition : moveDefinitions) {
                excludedMoveList.add(moveDefinition.getMoveName());
            }
        } else {
            SimpleTMs.LOGGER.info("Excluded moves config file not found. Creating empty excluded moves config file");
            try {
                FileWriter fileWriter = new FileWriter(excludedMovesFile);
                fileWriter.write("[]");
                fileWriter.close();
            }
            catch (Exception exception) {
                SimpleTMs.LOGGER.error("Failed to save config file for simpletms. Reason:");
                exception.printStackTrace();
            }
        }
    }

    public final void registerModItems() {
        SimpleTMs.LOGGER.info("Register Mod Items for simpletms");
        SimpleTMs.LOGGER.info("Loading default move configs for TMs and TRs");
        this.loadDefaultMoveConfig(defaultTMMoveConfigFile, false);
        this.loadDefaultMoveConfig(defaultTRMoveConfigFile, true);
        SimpleTMs.LOGGER.info("Registering default move TMs and TRs");
        if (SimpleTMs.INSTANCE.getConfig().getAllowItemRemovalATOWNRISK()) {
            this.registerMoveLearnItemsFromConfig(defaultTMMoveConfigFile, false);
            this.registerMoveLearnItemsFromConfig(defaultTRMoveConfigFile, true);
        } else {
            this.registerMoveLearnItemsFromResourceJSON(DEFAULT_MOVE_JSON_PATH);
        }
        ITEMS.register();
        SimpleTMs.LOGGER.info("Loading excluded moves from config");
        this.loadExcludedMovesFromConfig(movesExcludedFromPokemonDropsFile, ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS);
        this.loadExcludedMovesFromConfig(moveExcludedFromBlankLearningFile, ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING);
        this.loadExcludedMovesFromConfig(movesExcludedFromTMTRLearningFile, ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING);
    }

    @NotNull
    public final ItemStack getItemStackFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ResourceLocation identifier = MiscUtilsKt.simpletmsResource(name);
        Object object = BuiltInRegistries.ITEM.get(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Item item = (Item)object;
        ItemStack itemStack = new ItemStack((ItemLike)item);
        return itemStack;
    }

    private final Item getItemFromName(String name) {
        ResourceLocation identifier = MiscUtilsKt.simpletmsResource(name);
        Object object = BuiltInRegistries.ITEM.get(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Item item = (Item)object;
        return item;
    }

    @NotNull
    public final Item getTMorTRItemFromMove(@NotNull Move move, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        String prefix = isTR ? "tr_" : "tm_";
        String moveName = move.getName();
        Item newMoveLearnItem = this.getItemFromName(prefix + moveName);
        return newMoveLearnItem;
    }

    public final boolean hasItemForMove(@NotNull MoveTemplate move, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return isTR ? ALL_MOVE_NAMES_WITH_TR_ITEMS.contains(move.getName()) : ALL_MOVE_NAMES_WITH_TM_ITEMS.contains(move.getName());
    }

    private static final BlankTmItem registerBlankTmItem$lambda$0(boolean $isTR, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new BlankTmItem($isTR, $settings);
    }

    private static final MoveLearnItem registerMoveLearnItem$lambda$1(String $moveName, boolean $isTR, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$moveName, (String)"$moveName");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new MoveLearnItem($moveName, $isTR, $settings);
    }

    private static final MoveLearnItem registerMoveLearnItem$lambda$2(String $moveName, boolean $isTR, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$moveName, (String)"$moveName");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new MoveLearnItem($moveName, $isTR, $settings);
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((String)"simpletms", (ResourceKey)Registries.ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        ITEMS = deferredRegister;
        defaultTMMoveConfigFile = new File("config/simpletms/moves/default_tm_moves.json");
        defaultTRMoveConfigFile = new File("config/simpletms/moves/default_tr_moves.json");
        movesExcludedFromPokemonDropsFile = new File("config/simpletms/moves/excluded_moves_from_pokemon_drops.json");
        moveExcludedFromBlankLearningFile = new File("config/simpletms/moves/excluded_moves_from_blank_learning.json");
        movesExcludedFromTMTRLearningFile = new File("config/simpletms/moves/excluded_moves_from_tmtr_learning.json");
        ALL_MOVE_NAMES_WITH_TM_ITEMS = new ArrayList();
        ALL_MOVE_NAMES_WITH_TR_ITEMS = new ArrayList();
        ALL_MOVE_TEMPLATES_WITH_ITEMS = new ArrayList();
        ALL_REMOVED_DEFAULT_MOVES = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING = new ArrayList();
        TM_ITEMS = new ArrayList();
        TR_ITEMS = new ArrayList();
        BLANK_TM = INSTANCE.registerBlankTmItem("tm_blank", false);
        BLANK_TR = INSTANCE.registerBlankTmItem("tr_blank", true);
    }
}

