/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ConfigGuiHandler
extends ChestMenu {
    private final ModConfigs config;

    public ConfigGuiHandler(int syncId, Player player, SimpleContainer inventory, ModConfigs config) {
        super(MenuType.GENERIC_9x6, syncId, player.getInventory(), (Container)inventory, 6);
        this.config = config;
    }

    public void clicked(int slotId, int button, ClickType actionType, Player player) {
        if (player instanceof ServerPlayer && slotId >= 0 && slotId < this.slots.size()) {
            ItemStack clickedItem = this.getSlot(slotId).getItem();
            if (actionType == ClickType.PICKUP) {
                if (clickedItem.getItem() == Items.LIME_WOOL || clickedItem.getItem() == Items.RED_WOOL) {
                    this.toggleBooleanSetting(slotId);
                } else if (clickedItem.getItem() == Items.PURPLE_WOOL) {
                    this.cycleSetting(slotId);
                } else if (clickedItem.getItem() == Items.ORANGE_WOOL) {
                    this.promptChatInput(player, slotId);
                }
            }
        }
    }

    private void toggleBooleanSetting(int slot) {
        switch (slot) {
            case 9: {
                this.config.consume_items_on_successful_spawn = !this.config.consume_items_on_successful_spawn;
                this.updateWoolColor(slot, this.config.consume_items_on_successful_spawn);
                break;
            }
            case 10: {
                this.config.ignore_key_items = !this.config.ignore_key_items;
                this.updateWoolColor(slot, this.config.ignore_key_items);
                break;
            }
            case 11: {
                this.config.inventory_check_shulker_boxes = !this.config.inventory_check_shulker_boxes;
                this.updateWoolColor(slot, this.config.inventory_check_shulker_boxes);
                break;
            }
            case 12: {
                this.config.inventory_check_bundles = !this.config.inventory_check_bundles;
                this.updateWoolColor(slot, this.config.inventory_check_bundles);
                break;
            }
            case 13: {
                this.config.enable_force_spawning = !this.config.enable_force_spawning;
                this.updateWoolColor(slot, this.config.enable_force_spawning);
                break;
            }
            case 14: {
                this.config.server_only_mode = !this.config.server_only_mode;
                this.updateWoolColor(slot, this.config.server_only_mode);
                break;
            }
            case 30: {
                this.config.isBroadcastEnabled = !this.config.isBroadcastEnabled;
                this.updateWoolColor(slot, this.config.isBroadcastEnabled);
                break;
            }
            case 31: {
                this.config.broadcast_settings.get((int)0).settingValue = !this.config.broadcast_settings.get((int)0).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)0).settingValue);
                break;
            }
            case 32: {
                this.config.broadcast_settings.get((int)1).settingValue = !this.config.broadcast_settings.get((int)1).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)1).settingValue);
                break;
            }
            case 33: {
                this.config.broadcast_settings.get((int)2).settingValue = !this.config.broadcast_settings.get((int)2).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)2).settingValue);
                break;
            }
            case 34: {
                this.config.broadcast_settings.get((int)3).settingValue = !this.config.broadcast_settings.get((int)3).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)3).settingValue);
                break;
            }
            case 35: {
                this.config.broadcast_settings.get((int)4).settingValue = !this.config.broadcast_settings.get((int)4).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)4).settingValue);
                break;
            }
            case 45: {
                this.config.broadcast_settings.get((int)5).settingValue = !this.config.broadcast_settings.get((int)5).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)5).settingValue);
                break;
            }
            case 46: {
                this.config.broadcast_settings.get((int)6).settingValue = !this.config.broadcast_settings.get((int)6).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)6).settingValue);
                break;
            }
            case 47: {
                this.config.broadcast_settings.get((int)7).settingValue = !this.config.broadcast_settings.get((int)7).settingValue;
                this.updateWoolColor(slot, this.config.broadcast_settings.get((int)7).settingValue);
                break;
            }
            case 48: {
                this.config.form_changes = !this.config.form_changes;
                this.updateWoolColor(slot, this.config.form_changes);
            }
        }
        MythsAndLegends.getConfigManager().saveConfig();
    }

    private void cycleSetting(int slot) {
        switch (slot) {
            case 15: {
                List<String> spawnPoolValues = Arrays.asList("common", "uncommon", "rare", "ultra-rare");
                int currentSpawnPoolIndex = spawnPoolValues.indexOf(this.config.force_spawning_spawn_pool);
                this.config.force_spawning_spawn_pool = spawnPoolValues.get((currentSpawnPoolIndex + 1) % spawnPoolValues.size());
                this.updateCycleWool(slot, this.config.force_spawning_spawn_pool);
                break;
            }
            case 16: {
                List<String> intervalValues = Arrays.asList("600", "1200", "1800", "3600", "7200", "14400");
                int currentIntervalIndex = intervalValues.indexOf(String.valueOf(this.config.inventory_check_interval));
                this.config.inventory_check_interval = Integer.parseInt(intervalValues.get((currentIntervalIndex + 1) % intervalValues.size()));
                this.updateCycleWool(slot, String.valueOf(this.config.inventory_check_interval));
                break;
            }
            case 17: {
                List<String> cooldownValues = Arrays.asList("10", "20", "30", "60");
                int currentCooldownIndex = cooldownValues.indexOf(String.valueOf(this.config.force_spawn_item_cooldown));
                this.config.force_spawn_item_cooldown = Integer.parseInt(cooldownValues.get((currentCooldownIndex + 1) % cooldownValues.size()));
                this.updateCycleWool(slot, String.valueOf(this.config.force_spawn_item_cooldown));
                break;
            }
            case 27: {
                List<String> widthValues = Arrays.asList("50", "100", "150", "200");
                int currentWidthIndex = widthValues.indexOf(String.valueOf(this.config.force_spawn_check_width));
                this.config.force_spawn_check_width = Integer.parseInt(widthValues.get((currentWidthIndex + 1) % widthValues.size()));
                this.updateCycleWool(slot, String.valueOf(this.config.force_spawn_check_width));
                break;
            }
            case 28: {
                List<String> heightValues = Arrays.asList("25", "50", "75", "100");
                int currentHeightIndex = heightValues.indexOf(String.valueOf(this.config.force_spawn_check_height));
                this.config.force_spawn_check_height = Integer.parseInt(heightValues.get((currentHeightIndex + 1) % heightValues.size()));
                this.updateCycleWool(slot, String.valueOf(this.config.force_spawn_check_height));
                break;
            }
            case 49: {
                List<String> joinDelayValues = Arrays.asList("60", "80", "100", "120", "140");
                int currentJoinDelayIndex = joinDelayValues.indexOf(String.valueOf(this.config.join_form_aspect_delay));
                this.config.join_form_aspect_delay = Integer.parseInt(joinDelayValues.get((currentJoinDelayIndex + 1) % joinDelayValues.size()));
                this.updateCycleWool(slot, String.valueOf(this.config.join_form_aspect_delay));
            }
        }
        MythsAndLegends.getConfigManager().saveConfig();
    }

    private void promptChatInput(Player player, int slot) {
        if (slot == 32) {
            player.displayClientMessage(Component.nullToEmpty((String)"Please type the item name in the chat to add to the inventory check list."), false);
        }
        MythsAndLegends.getConfigManager().saveConfig();
    }

    private void updateWoolColor(int slot, boolean enabled) {
        ItemStack wool = new ItemStack((ItemLike)(enabled ? Items.LIME_WOOL : Items.RED_WOOL));
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)(enabled ? "Enabled" : "Disabled")));
        this.getSlot(slot).setByPlayer(wool);
        this.broadcastChanges();
    }

    private void updateCycleWool(int slot, String currentValue) {
        ItemStack wool = new ItemStack((ItemLike)Items.PURPLE_WOOL);
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)currentValue));
        this.getSlot(slot).setByPlayer(wool);
        this.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        MythsAndLegends.getConfigManager().saveConfig();
    }
}

