/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.KeyItemSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.PokemonSpeciesSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import com.github.d0ctorleon.mythsandlegends.permissions.MythsAndLegendsPermissions;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PersistentDataUtil;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Commands {
    private static final MythsAndLegendsPermissions PERMISSIONS = new MythsAndLegendsPermissions();

    public static boolean hasPermission(CommandSourceStack source, CobblemonPermission permission) {
        return MythsAndLegendsPermissions.checkPermission((SharedSuggestionProvider)source, permission);
    }

    public static void registerCommands() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> Commands.register((CommandDispatcher<CommandSourceStack>)dispatcher, registryAccess));
        MythsAndLegends.getLogger().debug("Start registering commands");
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"mythsandlegends").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"listitems").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_ITEMS_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(Commands::listItems)))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"checkinventory").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_INVENTORY_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(Commands::checkInventory)))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"applyaspectsandforms").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.APPLY_ASPECTS_AND_FORMS))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(Commands::applyAspectsAndForms)))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"listpokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_POKEMON_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(Commands::listPokemons)))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"checkpokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_POKEMON_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).then(net.minecraft.commands.Commands.argument((String)"pokemon", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).executes(Commands::checkForPokemon))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"setblockcheckspecies").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.SET_BLOCK_CHECK_SPECIES_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).then(net.minecraft.commands.Commands.argument((String)"species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).then(net.minecraft.commands.Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(net.minecraft.commands.Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)commandRegistryAccess)).executes(Commands::setblockcheckspecies))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"settings").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).executes(Commands::openSettingsGui)).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"forcespawn").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.FORCE_SPAWN_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).then(net.minecraft.commands.Commands.argument((String)"keyitem", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::forceSpawn))))));
        MythsAndLegends.getLogger().info("Registered Myths and Legends commands");
    }

    private static int listItems(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        PlayerDataUtils.PlayerData playerData = PlayerDataUtils.getPlayerData((Player)player);
        String itemsWithCounts = playerData.getFormattedItemsWithCounts();
        source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.items_in_inventory", (Object[])new Object[]{playerName, itemsWithCounts}), false);
        return 1;
    }

    private static int checkInventory(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        PlayerDataUtils.checkPlayerInventory((Player)player);
        source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.inventory_checked", (Object[])new Object[]{playerName}), false);
        return 1;
    }

    private static int listPokemons(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        List<Pokemon> pokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        if (pokemons.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.no_pokemon", (Object[])new Object[]{playerName}), false);
        } else {
            String pokemonList = pokemons.stream().map(pokemon -> String.format("%s (%s, Showdown ID: %s)", pokemon.getDisplayName().getString(), pokemon.getSpecies().getName(), pokemon.getSpecies().showdownId())).collect(Collectors.joining(", "));
            source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.pokemon_list", (Object[])new Object[]{playerName, pokemonList}), false);
        }
        return 1;
    }

    private static int checkForPokemon(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon");
        if (!Commands.isValidSpecies(speciesNameToCheck)) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.invalid_species", (Object[])new Object[]{speciesNameToCheck}));
            return 0;
        }
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        for (Pokemon partyPokemon : partyPokemons) {
            if (!partyPokemon.getSpecies().getName().equalsIgnoreCase(speciesNameToCheck)) continue;
            source.sendSuccess(() -> Component.translatable((String)"commands.myths_and_legends.has_pokemon", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.myths_and_legends.not_have_pokemon", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        return 1;
    }

    private static int setblockcheckspecies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String speciesName = StringArgumentType.getString(context, (String)"species");
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockInput block = BlockStateArgument.getBlock(context, (String)"block");
        if (!Commands.isValidSpecies(speciesName)) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.invalid_species", (Object[])new Object[]{speciesName}));
            return 0;
        }
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        if (!Commands.hasPokemon(targetPlayer, speciesName)) {
            source.sendFailure((Component)Component.translatable((String)"commands.myths_and_legends.setblockcheckspecies.does_not_have_pokemon", (Object[])new Object[]{playerName, speciesName}));
            return 0;
        }
        ServerLevel world = source.getLevel();
        if (!block.place(world, pos, 2)) {
            Narrator.LOGGER.error("Failed to set block at {}", (Object)pos);
        }
        world.blockUpdated(pos, block.getState().getBlock());
        source.sendSuccess(() -> Component.translatable((String)"commands.myths_and_legends.setblockcheckspecies.success", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
        return 1;
    }

    private static int forceSpawn(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String keyItemIdentifierPath = StringArgumentType.getString(context, (String)"keyitem");
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        boolean result = ForceSpawningUtils.forceSpawnv1command((Player)player, keyItemIdentifierPath);
        if (result) {
            source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.forcespawn.success", (Object[])new Object[]{playerName, keyItemIdentifierPath}), true);
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.forcespawn.failure", (Object[])new Object[]{playerName, keyItemIdentifierPath}));
        return 0;
    }

    private static boolean isValidSpecies(String speciesName) {
        Collection allSpecies = PokemonSpecies.INSTANCE.getSpecies();
        return allSpecies.stream().anyMatch(species -> species.getName().equalsIgnoreCase(speciesName));
    }

    private static boolean hasPokemon(ServerPlayer player, String speciesName) {
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        return partyPokemons.stream().anyMatch(pokemon -> pokemon.getSpecies().getName().equalsIgnoreCase(speciesName));
    }

    private static int openSettingsGui(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            source.sendFailure((Component)Component.translatable((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        ConfigGui configGui = new ConfigGui();
        configGui.openConfigGui(player, config);
        source.sendSuccess(() -> Component.translatable((String)"command.myths_and_legends.settings_gui_opened"), true);
        return 1;
    }

    private static int applyAspectsAndForms(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (player.level().isClientSide) {
            MythsAndLegends.getLogger().warn("onPlayerJoin called on client side! This should not happen.");
            return 0;
        }
        MythsAndLegends.getLogger().debug("Processing party data for player: " + player.getName().getString());
        Cobblemon.INSTANCE.getStorage().getParty(player).forEach(PersistentDataUtil::applyPersistentDataToPokemon);
        Cobblemon.INSTANCE.getStorage().getPC(player).forEach(PersistentDataUtil::applyPersistentDataToPokemon);
        MythsAndLegends.getLogger().debug("PC data processed successfully for player: " + player.getName().getString());
        return 1;
    }
}

