/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.platform.services;

import java.nio.file.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import xaero.common.controls.IKeyBindingHelper;
import xaero.common.controls.KeyBindingHelperNeoForge;
import xaero.common.misc.IObfuscatedReflection;
import xaero.common.misc.ObfuscatedReflectionNeoForge;
import xaero.common.platform.services.IPlatformHelper;
import xaero.hud.render.util.IPlatformRenderUtil;
import xaero.hud.render.util.NeoforgeRenderUtil;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private final ObfuscatedReflectionNeoForge obfuscatedReflectionNeoForge = new ObfuscatedReflectionNeoForge();
    private final KeyBindingHelperNeoForge keyBindingHelperNeoForge = new KeyBindingHelperNeoForge();
    private final NeoforgeRenderUtil neoforgeRenderUtil = new NeoforgeRenderUtil();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public IObfuscatedReflection getObfuscatedReflection() {
        return this.obfuscatedReflectionNeoForge;
    }

    @Override
    public IKeyBindingHelper getKeyBindingHelper() {
        return this.keyBindingHelperNeoForge;
    }

    @Override
    public IPlatformRenderUtil getPlatformRenderUtil() {
        return this.neoforgeRenderUtil;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getModFile(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId).getFile().getFilePath();
    }
}

