/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import java.util.HashMap;
import java.util.List;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.GridRefillHandler;
import net.blay09.mods.craftingtweaks.api.RecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.crafting.ContainerIngredientProvider;
import net.blay09.mods.craftingtweaks.crafting.CraftingContext;
import net.blay09.mods.craftingtweaks.crafting.CraftingOperation;
import net.blay09.mods.craftingtweaks.crafting.IngredientToken;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DefaultGridRefillHandler
implements GridRefillHandler<AbstractContainerMenu> {
    @Override
    public void refillRecipe(CraftingGrid grid, Player player, AbstractContainerMenu menu, RecipeHolder<?> recipeHolder, boolean stack) {
        HashMap<Integer, IngredientToken> matrixDiff;
        grid.clearHandler().clearGrid(grid, player, menu, true);
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        Recipe recipe = recipeHolder.value();
        CraftingContext context = new CraftingContext(List.of(new ContainerIngredientProvider((Container)player.getInventory())));
        CraftingOperation operation = context.createOperation(recipeHolder).prepare();
        if (!operation.canCraft()) {
            return;
        }
        int operations = 0;
        block0: do {
            List<IngredientToken> ingredientTokens = operation.getIngredientTokens();
            RecipeMatrixMapper<Recipe> matrixMapper = CraftingTweaksAPI.getRecipeMatrixMapper(recipe.getClass());
            matrixDiff = new HashMap<Integer, IngredientToken>();
            for (int i = 0; i < ingredientTokens.size(); ++i) {
                IngredientToken ingredientToken2 = ingredientTokens.get(i);
                int matrixSlot = matrixMapper.mapToMatrixSlot(recipe, i);
                if (matrixSlot == -1) continue;
                ItemStack itemStack = ingredientToken2.peek();
                ItemStack slotStack = craftMatrix.getItem(matrixSlot);
                if (!slotStack.isEmpty() && (slotStack.getCount() >= slotStack.getMaxStackSize() || !slotStack.isStackable() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack))) break block0;
                matrixDiff.put(matrixSlot, ingredientToken2);
            }
            matrixDiff.forEach((slot, ingredientToken) -> {
                ItemStack slotStack = craftMatrix.getItem(slot.intValue());
                ItemStack itemStack = ingredientToken.consume();
                craftMatrix.setItem(slot.intValue(), itemStack.copyWithCount(itemStack.getCount() + slotStack.getCount()));
            });
            if (++operations <= 64) continue;
            CraftingTweaks.logger.warn("Something went wrong trying to refill recipe. Too many iterations. Recipe: {}", (Object)recipeHolder.id());
            break;
        } while (stack && !matrixDiff.isEmpty() && operation.prepare().canCraft());
        menu.broadcastChanges();
    }
}

