/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.impl;

import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.impl.DefaultChunkMeshAttributes;
import net.minecraft.util.Mth;
import org.lwjgl.system.MemoryUtil;

public class CompactChunkVertex
implements ChunkVertexType {
    public static final int STRIDE = 20;
    public static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(20).addElement(DefaultChunkMeshAttributes.POSITION, 0, 0).addElement(DefaultChunkMeshAttributes.COLOR, 1, 8).addElement(DefaultChunkMeshAttributes.TEXTURE, 2, 12).addElement(DefaultChunkMeshAttributes.LIGHT_MATERIAL_INDEX, 3, 16).build();
    private static final int POSITION_MAX_VALUE = 0x100000;
    private static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder getEncoder() {
        return (ptr, materialBits, vertices, section) -> {
            float texCentroidU = 0.0f;
            float texCentroidV = 0.0f;
            for (ChunkVertexEncoder.Vertex vertex : vertices) {
                texCentroidU += vertex.u;
                texCentroidV += vertex.v;
            }
            texCentroidU *= 0.25f;
            texCentroidV *= 0.25f;
            for (int i = 0; i < 4; ++i) {
                ChunkVertexEncoder.Vertex vertex = vertices[i];
                int x = CompactChunkVertex.quantizePosition(vertex.x);
                int y = CompactChunkVertex.quantizePosition(vertex.y);
                int z = CompactChunkVertex.quantizePosition(vertex.z);
                int u = CompactChunkVertex.encodeTexture(texCentroidU, vertex.u);
                int v = CompactChunkVertex.encodeTexture(texCentroidV, vertex.v);
                int light = CompactChunkVertex.encodeLight(vertex.light);
                MemoryUtil.memPutInt((long)(ptr + 0L), (int)CompactChunkVertex.packPositionHi(x, y, z));
                MemoryUtil.memPutInt((long)(ptr + 4L), (int)CompactChunkVertex.packPositionLo(x, y, z));
                MemoryUtil.memPutInt((long)(ptr + 8L), (int)ColorARGB.mulRGB(vertex.color, vertex.ao));
                MemoryUtil.memPutInt((long)(ptr + 12L), (int)CompactChunkVertex.packTexture(u, v));
                MemoryUtil.memPutInt((long)(ptr + 16L), (int)CompactChunkVertex.packLightAndData(light, materialBits, section));
                ptr += 20L;
            }
            return ptr;
        };
    }

    private static int packPositionHi(int x, int y, int z) {
        return (x >>> 10 & 0x3FF) << 0 | (y >>> 10 & 0x3FF) << 10 | (z >>> 10 & 0x3FF) << 20;
    }

    private static int packPositionLo(int x, int y, int z) {
        return (x & 0x3FF) << 0 | (y & 0x3FF) << 10 | (z & 0x3FF) << 20;
    }

    private static int quantizePosition(float position) {
        return (int)(CompactChunkVertex.normalizePosition(position) * 1048576.0f) & 0xFFFFF;
    }

    private static float normalizePosition(float v) {
        return (8.0f + v) / 32.0f;
    }

    private static int packTexture(int u, int v) {
        return (u & 0xFFFF) << 0 | (v & 0xFFFF) << 16;
    }

    private static int encodeTexture(float center, float x) {
        int bias = x < center ? 1 : -1;
        int quantized = CompactChunkVertex.floorInt(x * 32768.0f) + bias;
        return quantized & Short.MAX_VALUE | CompactChunkVertex.sign(bias) << 15;
    }

    private static int encodeLight(int light) {
        int sky = Mth.clamp((int)(light >>> 16 & 0xFF), (int)8, (int)248);
        int block = Mth.clamp((int)(light >>> 0 & 0xFF), (int)8, (int)248);
        return block << 0 | sky << 8;
    }

    private static int packLightAndData(int light, int material, int section) {
        return (light & 0xFFFF) << 0 | (material & 0xFF) << 16 | (section & 0xFF) << 24;
    }

    private static int sign(int x) {
        return x >>> 31;
    }

    private static int floorInt(float x) {
        return (int)Math.floor(x);
    }
}

