/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteArrayIterator;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.util.iterator.ReversibleByteArrayIterator;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ChunkRenderList {
    private final RenderRegion region;
    private final byte[] sectionsWithGeometry = new byte[256];
    private int sectionsWithGeometryCount = 0;
    private final byte[] sectionsWithSprites = new byte[256];
    private int sectionsWithSpritesCount = 0;
    private final byte[] sectionsWithEntities = new byte[256];
    private int sectionsWithEntitiesCount = 0;
    private int size;
    private int lastVisibleFrame;
    private static final int SORTING_HISTOGRAM_SIZE = 18;

    public ChunkRenderList(RenderRegion region) {
        this.region = region;
    }

    public void reset(int frame) {
        this.sectionsWithGeometryCount = 0;
        this.sectionsWithSpritesCount = 0;
        this.sectionsWithEntitiesCount = 0;
        this.size = 0;
        this.lastVisibleFrame = frame;
    }

    public void sortSections(CameraTransform transform, int[] sortItems) {
        int i;
        int cameraX = Mth.clamp((int)((transform.intX >> 4) - this.region.getChunkX()), (int)0, (int)7);
        int cameraY = Mth.clamp((int)((transform.intY >> 4) - this.region.getChunkY()), (int)0, (int)3);
        int cameraZ = Mth.clamp((int)((transform.intZ >> 4) - this.region.getChunkZ()), (int)0, (int)7);
        int[] histogram = new int[18];
        for (i = 0; i < this.sectionsWithGeometryCount; ++i) {
            int distance;
            int index = this.sectionsWithGeometry[i] & 0xFF;
            int x = Math.abs(LocalSectionIndex.unpackX(index) - cameraX);
            int y = Math.abs(LocalSectionIndex.unpackY(index) - cameraY);
            int z = Math.abs(LocalSectionIndex.unpackZ(index) - cameraZ);
            int n = distance = x + y + z;
            histogram[n] = histogram[n] + 1;
            sortItems[i] = distance << 8 | index;
        }
        for (i = 1; i < 18; ++i) {
            int n = i;
            histogram[n] = histogram[n] + histogram[i - 1];
        }
        for (i = 0; i < this.sectionsWithGeometryCount; ++i) {
            int distance;
            int item = sortItems[i];
            int n = distance = item >>> 8;
            int n2 = histogram[n] - 1;
            histogram[n] = n2;
            this.sectionsWithGeometry[n2] = (byte)item;
        }
    }

    public void add(RenderSection render) {
        if (this.size >= 256) {
            throw new ArrayIndexOutOfBoundsException("Render list is full");
        }
        ++this.size;
        int index = render.getSectionIndex();
        int flags = render.getFlags();
        this.sectionsWithGeometry[this.sectionsWithGeometryCount] = (byte)index;
        this.sectionsWithGeometryCount += flags >>> 0 & 1;
        this.sectionsWithSprites[this.sectionsWithSpritesCount] = (byte)index;
        this.sectionsWithSpritesCount += flags >>> 2 & 1;
        this.sectionsWithEntities[this.sectionsWithEntitiesCount] = (byte)index;
        this.sectionsWithEntitiesCount += flags >>> 1 & 1;
    }

    @Nullable
    public ByteIterator sectionsWithGeometryIterator(boolean reverse) {
        if (this.sectionsWithGeometryCount == 0) {
            return null;
        }
        return new ReversibleByteArrayIterator(this.sectionsWithGeometry, this.sectionsWithGeometryCount, reverse);
    }

    @Nullable
    public ByteIterator sectionsWithSpritesIterator() {
        if (this.sectionsWithSpritesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithSprites, this.sectionsWithSpritesCount);
    }

    @Nullable
    public ByteIterator sectionsWithEntitiesIterator() {
        if (this.sectionsWithEntitiesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithEntities, this.sectionsWithEntitiesCount);
    }

    public int getSectionsWithGeometryCount() {
        return this.sectionsWithGeometryCount;
    }

    public int getSectionsWithSpritesCount() {
        return this.sectionsWithSpritesCount;
    }

    public int getSectionsWithEntitiesCount() {
        return this.sectionsWithEntitiesCount;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public int size() {
        return this.size;
    }
}

