/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.yumi.commons.TriState;
import dev.yumi.commons.Unit;
import dev.yumi.commons.event.Event;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemLightSources
implements ItemLightSourceManager,
PreparableReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|ItemLightSources");
    private static final ResourceLocation RESOURCE_RELOADER_ID = ResourceLocation.fromNamespaceAndPath((String)"lambdynlights", (String)"dynamiclights_resources");
    private static final String SILENCE_ERROR_KEY = "silence_error";
    private static final boolean FORCE_LOG_ERRORS = TriState.fromProperty("lambdynamiclights.resource.force_log_errors").toBooleanOrElse(SharedConstants.IS_RUNNING_IN_IDE);
    private final Event<ResourceLocation, ItemLightSourceManager.OnRegister> onRegisterEvent = LambDynLights.EVENT_MANAGER.create(ItemLightSourceManager.OnRegister.class);
    private final Minecraft client = Minecraft.getInstance();
    private final List<LoadedItemLightSource> loadedLightSources = new ArrayList<LoadedItemLightSource>();
    private final List<ItemLightSource> lightSources = new ArrayList<ItemLightSource>();

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.load(resourceManager);
            return Unit.INSTANCE;
        }, prepareExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)synchronizer).wait(arg_0))).thenAcceptAsync(reloadState -> {
            if (this.client.level != null) {
                this.apply(this.client.level.registryAccess());
            }
        }, applyExecutor);
    }

    public void load(ResourceManager resourceManager) {
        this.loadedLightSources.clear();
        resourceManager.listResources("dynamiclights/item", path -> path.getPath().endsWith(".json")).forEach(this::load);
    }

    public void apply(final RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        this.lightSources.clear();
        this.loadedLightSources.forEach(data -> this.apply((DynamicOps<JsonElement>)ops, (LoadedItemLightSource)data));
        this.onRegisterEvent.invoker().onRegister(new ItemLightSourceManager.RegisterContext(){

            @Override
            public RegistryAccess registryAccess() {
                return registryAccess;
            }

            @Override
            public void register(ItemLightSource itemLightSource) {
                ItemLightSources.this.lightSources.add(itemLightSource);
            }
        });
    }

    private void load(ResourceLocation resourceId, Resource resource) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)resourceId.getNamespace(), (String)resourceId.getPath().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.open());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            if (!rawJson.isJsonObject()) {
                LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\". Expected JSON object in file.", id);
                return;
            }
            JsonObject json = rawJson.getAsJsonObject();
            boolean silentError = false;
            if (json.has(SILENCE_ERROR_KEY)) {
                silentError = json.get(SILENCE_ERROR_KEY).getAsBoolean();
                json.remove(SILENCE_ERROR_KEY);
            }
            this.loadedLightSources.add(new LoadedItemLightSource(id, json, silentError));
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\".", id, e);
        }
    }

    private void apply(DynamicOps<JsonElement> ops, LoadedItemLightSource loadedData) {
        DataResult loaded = ItemLightSource.CODEC.parse(ops, (Object)loadedData.data());
        if (!loadedData.silenceError() || FORCE_LOG_ERRORS) {
            loaded.ifError(error -> LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\" due to error: {}", loadedData.id(), error.message()));
        }
        loaded.ifSuccess(this.lightSources::add);
    }

    @Override
    public Event<ResourceLocation, ItemLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    @Override
    public int getLuminance(ItemStack stack, boolean submergedInWater) {
        boolean shouldCareAboutWater = submergedInWater && (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get() != false;
        int luminance = 0;
        boolean matchedAny = false;
        for (ItemLightSource data : this.lightSources) {
            if (!data.predicate().test(stack)) continue;
            matchedAny = true;
            if (shouldCareAboutWater && data.waterSensitive()) continue;
            luminance = Math.max(luminance, data.getLuminance(stack));
        }
        if (!matchedAny) {
            luminance = Block.byItem((Item)stack.getItem()).defaultBlockState().getLightEmission();
        }
        return luminance;
    }

    record LoadedItemLightSource(ResourceLocation id, JsonObject data, boolean silenceError) {
    }
}

