/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mod.shared.network.compression;

import com.google.common.base.Preconditions;
import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class MinecraftCompressDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final int VANILLA_MAXIMUM_UNCOMPRESSED_SIZE = 0x800000;
    private static final int HARD_MAXIMUM_UNCOMPRESSED_SIZE = 0x8000000;
    private static final int UNCOMPRESSED_CAP = Boolean.getBoolean("krypton.permit-oversized-packets") ? 0x8000000 : 0x800000;
    private int threshold;
    private final VelocityCompressor compressor;
    private final boolean validate;

    public MinecraftCompressDecoder(int threshold, boolean validate, VelocityCompressor compressor) {
        this.threshold = threshold;
        this.compressor = compressor;
        this.validate = validate;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        FriendlyByteBuf bb = new FriendlyByteBuf(in);
        int claimedUncompressedSize = bb.readVarInt();
        if (claimedUncompressedSize == 0) {
            out.add(in.retain());
            return;
        }
        if (this.validate) {
            Preconditions.checkState((claimedUncompressedSize >= this.threshold ? 1 : 0) != 0, (String)"Uncompressed size %s is less than threshold %s", (int)claimedUncompressedSize, (int)this.threshold);
            Preconditions.checkState((claimedUncompressedSize <= UNCOMPRESSED_CAP ? 1 : 0) != 0, (String)"Uncompressed size %s exceeds hard threshold of %s", (int)claimedUncompressedSize, (int)UNCOMPRESSED_CAP);
        }
        ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)in);
        ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
        try {
            this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
            out.add(uncompressed);
        }
        catch (Exception e) {
            uncompressed.release();
            throw e;
        }
        finally {
            compatibleIn.release();
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

