/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;

public class ModUtils {
    public static final String MCVersion = SharedConstants.getCurrentVersion().getName();
    public static final int MCProtocolID = SharedConstants.getCurrentVersion().getProtocolVersion();
    public static final String BRAND = CoreUtils.findGameBrand(ClientBrandRetriever.getClientModName());
    public static final TranslationUtils RAW_TRANSLATOR = CoreUtils.findGameTranslations(MCProtocolID);
    private static final Supplier<Minecraft> INSTANCE_GETTER = Minecraft::getInstance;
    private static final BiConsumer<String, ResourceManagerReloadListener> RELOAD_LISTENER_HOOK = (id, listener) -> ((ReloadableResourceManager)ModUtils.getMinecraft().getResourceManager()).registerReloadListener((PreparableReloadListener)listener);
    private static final BiConsumer<Minecraft, Runnable> MAIN_THREAD_EXECUTOR = BlockableEventLoop::execute;

    public static Supplier<Minecraft> getMinecraftSupplier() {
        return INSTANCE_GETTER;
    }

    public static Minecraft getMinecraft() {
        return ModUtils.getMinecraftSupplier().get();
    }

    public static String getLanguage(String fallback) {
        String result = ModUtils.getMinecraft().options != null ? ModUtils.getMinecraft().options.languageCode : fallback;
        return result;
    }

    public static String getLanguage() {
        return ModUtils.getLanguage(CoreUtils.getDefaultLanguage());
    }

    public static void registerReloadListener(String id, ResourceManagerReloadListener listener) {
        RELOAD_LISTENER_HOOK.accept(id, listener);
    }

    public static void executeOnMainThread(Minecraft client, Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(client, event);
    }

    public static void executeOnMainThread(Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(ModUtils.getMinecraft(), event);
    }
}

