/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockPickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade,
IBlockPickResponseUpgrade {
    private static final int COOLDOWN = 5;
    public static final Codec<Map<Integer, TargetSlot>> TARGET_SLOTS_CODEC = Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_INT, TargetSlot.CODEC);
    public static final StreamCodec<FriendlyByteBuf, Map<Integer, TargetSlot>> TARGET_SLOTS_STREAM_CODEC = StreamCodecHelper.ofMap((StreamCodec)ByteBufCodecs.INT, TargetSlot.STREAM_CODEC, HashMap::new);
    private final Map<Integer, TargetSlot> targetSlots;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((RefillUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.targetSlots = new HashMap<Integer, TargetSlot>((Map)upgrade.getOrDefault(ModDataComponents.TARGET_SLOTS, new HashMap()));
        if (((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection()) {
            FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
            filterHandler.setOnSlotChange(s -> this.onFilterChange(filterHandler, s));
        }
        this.filterLogic.setAllowByDefault(true);
    }

    private void onFilterChange(FilterLogic.ObservableFilterItemStackHandler filterHandler, int slot) {
        if (filterHandler.getStackInSlot(slot).isEmpty()) {
            this.targetSlots.remove(slot);
            this.saveTargetSlots();
        } else if (!this.targetSlots.containsKey(slot)) {
            this.setTargetSlot(slot, TargetSlot.ANY);
        }
    }

    public Map<Integer, TargetSlot> getTargetSlots() {
        return this.targetSlots;
    }

    public void setTargetSlot(int slot, TargetSlot targetSlot) {
        this.targetSlots.put(slot, targetSlot);
        this.saveTargetSlots();
    }

    private void saveTargetSlots() {
        this.upgrade.set(ModDataComponents.TARGET_SLOTS, (Object)ImmutableMap.copyOf(this.targetSlots));
        this.save();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (entity == null || this.isInCooldown(level)) {
            return;
        }
        CapabilityHelper.runOnItemHandler((Entity)entity, playerInvHandler -> InventoryHelper.iterate((IItemHandler)this.filterLogic.getFilterHandler(), (slot, filter) -> {
            if (filter.isEmpty()) {
                return;
            }
            this.tryRefillFilter(entity, (IItemHandler)playerInvHandler, (ItemStack)filter, this.getTargetSlots().getOrDefault(slot, TargetSlot.ANY));
        }));
        this.setCooldown(level, 5);
    }

    private void tryRefillFilter(@Nonnull Entity entity, IItemHandler playerInvHandler, ItemStack filter, TargetSlot targetSlot) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int missingCount = targetSlot.missingCountGetter.getMissingCount(player, playerInvHandler, filter);
        if (ItemStack.isSameItemSameComponents((ItemStack)player.containerMenu.getCarried(), (ItemStack)filter)) {
            missingCount -= Math.min(missingCount, player.containerMenu.getCarried().getCount());
        }
        if (missingCount == 0) {
            return;
        }
        ITrackedContentsItemHandler extractFromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemStack toMove = filter.copy();
        toMove.setCount(missingCount);
        ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toMove, (IItemHandler)extractFromHandler, (boolean)true);
        if (extracted.isEmpty()) {
            return;
        }
        ItemStack remaining = targetSlot.filler.fill(player, playerInvHandler, extracted);
        if (remaining.getCount() != extracted.getCount()) {
            ItemStack toExtract = extracted.copy();
            toExtract.setCount(extracted.getCount() - remaining.getCount());
            InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)extractFromHandler, (boolean)false);
        }
    }

    public boolean allowsTargetSlotSelection() {
        return ((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection();
    }

    @Override
    public boolean pickBlock(Player player, ItemStack filter) {
        if (!((RefillUpgradeItem)this.upgradeItem).supportsBlockPick()) {
            return false;
        }
        AtomicInteger stashSlot = new AtomicInteger(-1);
        AtomicBoolean hasItemInBackpack = new AtomicBoolean(false);
        ITrackedContentsItemHandler inventoryHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filter)) {
                hasItemInBackpack.set(true);
                stashSlot.set((int)slot);
            }
        }, () -> stashSlot.get() > -1);
        ItemStack mainHandItem = player.getMainHandItem();
        ItemStack toExtract = filter.copy();
        toExtract.setCount(filter.getMaxStackSize());
        if (hasItemInBackpack.get() && !InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)true).isEmpty()) {
            if (!(inventoryHandler.getStackInSlot(stashSlot.get()).getCount() <= filter.getMaxStackSize() && inventoryHandler.isItemValid(stashSlot.get(), mainHandItem) || inventoryHandler.insertItem(mainHandItem, true).isEmpty())) {
                if (this.canMoveMainHandToInventory(player)) {
                    ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)false);
                    player.setItemInHand(InteractionHand.MAIN_HAND, extracted);
                    player.getInventory().add(mainHandItem);
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"gui.sophisticatedbackpacks.status.no_space_for_mainhand_item"), true);
                return false;
            }
            ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toExtract, (IItemHandler)inventoryHandler, (boolean)false);
            inventoryHandler.insertItem(mainHandItem, false);
            player.setItemInHand(InteractionHand.MAIN_HAND, extracted);
            return true;
        }
        return false;
    }

    private boolean canMoveMainHandToInventory(Player player) {
        int countToAdd = player.getMainHandItem().getCount();
        for (int slot = 0; slot < player.getInventory().getContainerSize() - 5; ++slot) {
            if (slot == player.getInventory().selected) continue;
            ItemStack slotStack = player.getInventory().getItem(slot);
            if (slotStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)player.getMainHandItem()) || (countToAdd -= slotStack.getMaxStackSize() - slotStack.getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static enum TargetSlot implements StringRepresentable
    {
        ANY("any", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> InventoryHelper.getCountMissingInHandler((IItemHandler)playerInvHandler, (ItemStack)filter, (int)filter.getMaxStackSize()), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillAnywhereInInventory(playerInvHandler, stackToAdd)),
        MAIN_HAND("main_hand", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getMainHandItem(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).getMainHandItem(), stackToAdd, stack -> player.setItemInHand(InteractionHand.MAIN_HAND, stack))),
        OFF_HAND("off_hand", (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand", new Object[0]), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getOffhandItem(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).getOffhandItem(), stackToAdd, stack -> player.setItemInHand(InteractionHand.OFF_HAND, stack))),
        TOOLBAR_1("toolbar_1", (Component)Component.literal((String)"1"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{1}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(0), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(0), stackToAdd, stack -> player.getInventory().setItem(0, stack))),
        TOOLBAR_2("toolbar_2", (Component)Component.literal((String)"2"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{2}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(1), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(1), stackToAdd, stack -> player.getInventory().setItem(1, stack))),
        TOOLBAR_3("toolbar_3", (Component)Component.literal((String)"3"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{3}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(2), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(2), stackToAdd, stack -> player.getInventory().setItem(2, stack))),
        TOOLBAR_4("toolbar_4", (Component)Component.literal((String)"4"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{4}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(3), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(3), stackToAdd, stack -> player.getInventory().setItem(3, stack))),
        TOOLBAR_5("toolbar_5", (Component)Component.literal((String)"5"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{5}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(4), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(4), stackToAdd, stack -> player.getInventory().setItem(4, stack))),
        TOOLBAR_6("toolbar_6", (Component)Component.literal((String)"6"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{6}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(5), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(5), stackToAdd, stack -> player.getInventory().setItem(5, stack))),
        TOOLBAR_7("toolbar_7", (Component)Component.literal((String)"7"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{7}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(6), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(6), stackToAdd, stack -> player.getInventory().setItem(6, stack))),
        TOOLBAR_8("toolbar_8", (Component)Component.literal((String)"8"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{8}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(7), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(7), stackToAdd, stack -> player.getInventory().setItem(7, stack))),
        TOOLBAR_9("toolbar_9", (Component)Component.literal((String)"9"), (Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{9}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(8), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(8), stackToAdd, stack -> player.getInventory().setItem(8, stack)));

        private final String name;
        private final Component acronym;
        private final Component description;
        private final MissingCountGetter missingCountGetter;
        private final Filler filler;
        public static final Codec<TargetSlot> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TargetSlot> STREAM_CODEC;
        private static final Map<String, TargetSlot> NAME_VALUES;
        private static final TargetSlot[] VALUES;

        private TargetSlot(String name, Component acronym, Component description, MissingCountGetter missingCountGetter, Filler filler) {
            this.name = name;
            this.acronym = acronym;
            this.description = description;
            this.missingCountGetter = missingCountGetter;
            this.filler = filler;
        }

        public String getSerializedName() {
            return this.name;
        }

        public TargetSlot next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public TargetSlot previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        public static TargetSlot fromName(String name) {
            return NAME_VALUES.getOrDefault(name, ANY);
        }

        public Component getAcronym() {
            return this.acronym;
        }

        public Component getDescription() {
            return this.description;
        }

        private static ItemStack refillAnywhereInInventory(IItemHandler playerInvHandler, ItemStack extracted) {
            AtomicReference<ItemStack> remainingStack = new AtomicReference<ItemStack>(extracted);
            InventoryHelper.iterate((IItemHandler)playerInvHandler, (slot, stack) -> {
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)remainingStack.get()))) {
                    remainingStack.set(playerInvHandler.insertItem(slot.intValue(), (ItemStack)remainingStack.get(), false));
                }
            }, () -> ((ItemStack)remainingStack.get()).isEmpty());
            ItemStack remaining = remainingStack.get();
            if (!remaining.isEmpty()) {
                ItemStack afterInsert = InventoryHelper.insertIntoInventory((ItemStack)remaining, (IItemHandler)playerInvHandler, (boolean)true);
                if (afterInsert.getCount() == remaining.getCount()) {
                    return remaining;
                }
                ItemStack toInsert = remaining.copy();
                toInsert.setCount(remaining.getCount() - afterInsert.getCount());
                return InventoryHelper.insertIntoInventory((ItemStack)toInsert, (IItemHandler)playerInvHandler, (boolean)false);
            }
            return remaining;
        }

        private static int getMissingCount(ItemStack stack, ItemStack filter) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filter)) {
                return filter.getMaxStackSize() - stack.getCount();
            }
            return filter.getMaxStackSize();
        }

        private static ItemStack refillSlot(Supplier<ItemStack> getSlotContents, ItemStack stackToAdd, Consumer<ItemStack> setSlotContents) {
            ItemStack contents = getSlotContents.get();
            if (contents.isEmpty()) {
                setSlotContents.accept(stackToAdd);
                return ItemStack.EMPTY;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)contents, (ItemStack)stackToAdd)) {
                contents.grow(stackToAdd.getCount());
                return ItemStack.EMPTY;
            }
            return stackToAdd;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TargetSlot::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(TargetSlot.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (TargetSlot value : TargetSlot.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            NAME_VALUES = builder.build();
            VALUES = TargetSlot.values();
        }

        private static interface MissingCountGetter {
            public int getMissingCount(Player var1, IItemHandler var2, ItemStack var3);
        }

        private static interface Filler {
            public ItemStack fill(Player var1, IItemHandler var2, ItemStack var3);
        }

        private static class Constants {
            private static final String HOTBAR_TRANSL = "refill.target_slot.hotbar.tooltip";

            private Constants() {
            }
        }
    }
}

