/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.state;

import dynamic_fps.impl.config.option.GraphicsState;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;

public class OptionHolder {
    private static CloudStatus cloudStatus;
    private static GraphicsStatus graphicsStatus;
    private static boolean ambientOcclusion;
    private static ParticleStatus particlesStatus;
    private static boolean entityShadows;
    private static double entityDistance;

    public static void copyOptions(Options options) {
        cloudStatus = options.getCloudsType();
        graphicsStatus = (GraphicsStatus)options.graphicsMode().get();
        ambientOcclusion = (Boolean)options.ambientOcclusion().get();
        particlesStatus = (ParticleStatus)options.particles().get();
        entityShadows = (Boolean)options.entityShadows().get();
        entityDistance = (Double)options.entityDistanceScaling().get();
    }

    public static void applyOptions(Options options, GraphicsState state) {
        if (state == GraphicsState.DEFAULT) {
            options.cloudStatus().set((Object)cloudStatus);
            options.graphicsMode().set((Object)graphicsStatus);
            options.ambientOcclusion().set((Object)ambientOcclusion);
            options.particles().set((Object)particlesStatus);
            options.entityShadows().set((Object)entityShadows);
            options.entityDistanceScaling().set((Object)entityDistance);
        } else {
            options.cloudStatus().set((Object)CloudStatus.OFF);
            options.particles().set((Object)ParticleStatus.MINIMAL);
            options.entityShadows().set((Object)false);
            options.entityDistanceScaling().set((Object)0.5);
            if (state == GraphicsState.MINIMAL) {
                options.graphicsMode().set((Object)GraphicsStatus.FAST);
                options.ambientOcclusion().set((Object)false);
            }
        }
    }
}

