/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownTextFragment;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EMPTY_STRING = "";
    private static final char NEWLINE_CHAR = '\n';
    private static final String NEWLINE = "\n";
    private static final String HEADLINE_PREFIX_BIGGEST = "# ";
    private static final String HEADLINE_PREFIX_BIGGER = "## ";
    private static final String HEADLINE_PREFIX_BIG = "### ";
    private static final char HASHTAG_CHAR = '#';
    private static final String FORMATTING_CODE_FONT_PREFIX = "%!!";
    private static final String FORMATTING_CODE_FONT_SUFFIX = "%!!%";
    private static final String PERCENTAGE = "%";
    private static final char PERCENTAGE_CHAR = '%';
    private static final String FORMATTING_CODE_HEX_COLOR_PREFIX = "%#";
    private static final String FORMATTING_CODE_HEX_COLOR_SUFFIX = "%#%";
    private static final char ASTERISK_CHAR = '*';
    private static final String FORMATTING_CODE_BOLD_PREFIX_SUFFIX = "**";
    private static final char UNDERSCORE_CHAR = '_';
    private static final char TILDE_CHAR = '~';
    private static final char EXCLAMATION_MARK_CHAR = '!';
    private static final String FORMATTING_CODE_IMAGE_PREFIX = "![";
    private static final String FORMATTING_CODE_HYPERLINK_IMAGE_PREFIX = "[![";
    private static final String FORMATTING_CODE_HYPERLINK_INNER_PREFIX = "](";
    private static final char OPEN_ROUND_BRACKETS_CHAR = '(';
    private static final char CLOSE_ROUND_BRACKETS_CHAR = ')';
    private static final String CLOSE_ROUND_BRACKETS = ")";
    private static final char OPEN_SQUARE_BRACKETS_CHAR = '[';
    private static final char CLOSE_SQUARE_BRACKETS_CHAR = ']';
    private static final String OPEN_SQUARE_BRACKETS = "[";
    private static final char GREATER_THAN_CHAR = '>';
    private static final String FORMATTING_CODE_QUOTE_PREFIX = "> ";
    private static final String SPACE = " ";
    private static final char SPACE_CHAR = ' ';
    private static final String FORMATTING_CODE_BULLET_LIST_LEVEL_1_PREFIX = "- ";
    private static final String FORMATTING_CODE_BULLET_LIST_LEVEL_2_PREFIX = "  - ";
    private static final String MINUS = "-";
    private static final char MINUS_CHAR = '-';
    private static final String FORMATTING_CODE_SEPARATION_LINE_PREFIX = "---";
    private static final char GRAVE_ACCENT_CHAR = '`';
    private static final String FORMATTING_CODE_CODE_BLOCK_MULTI_LINE_PREFIX_SUFFIX = "```";
    private static final char CIRCUMFLEX_CHAR = '^';
    private static final String CIRCUMFLEX = "^";
    private static final String FORMATTING_CODE_ALIGNMENT_CENTERED_PREFIX_SUFFIX = "^^^";
    private static final char VERTICAL_BAR_CHAR = '|';
    private static final String FORMATTING_CODE_ALIGNMENT_RIGHT_PREFIX_SUFFIX = "|||";
    private static final String VERTICAL_BAR = "|";
    private static final CharacterFilter RESOURCE_NAME_FILTER = CharacterFilter.buildResourceNameFilter();
    private static final CharacterFilter MINUS_CHARACTER_FILTER = ObjectUtils.build(() -> {
        CharacterFilter filter = new CharacterFilter();
        filter.addAllowedCharacters('-');
        return filter;
    });

    @NotNull
    public static List<MarkdownTextFragment> parse(@NotNull MarkdownRenderer renderer, @NotNull String markdownText, boolean parseMarkdown) {
        Objects.requireNonNull(renderer);
        Objects.requireNonNull(markdownText);
        ArrayList<MarkdownTextFragment> fragments = new ArrayList<MarkdownTextFragment>();
        FragmentBuilder builder = new FragmentBuilder(renderer);
        boolean queueNewLine = true;
        boolean italicUnderscore = false;
        int charsToSkip = 0;
        boolean skipLine = false;
        MarkdownTextFragment lastBuiltFragment = null;
        boolean lastLineWasHeadline = false;
        String currentLine = EMPTY_STRING;
        int index = -1;
        for (char c : markdownText.toCharArray()) {
            boolean isStartOfLine = queueNewLine;
            queueNewLine = false;
            String subText = StringUtils.substring((String)markdownText, (int)(++index));
            String subLine = MarkdownParser.getLine(subText);
            if (isStartOfLine) {
                currentLine = MarkdownParser.getLine(subText);
            }
            if (c == '\n' && lastLineWasHeadline) {
                String nextLine = null;
                try {
                    nextLine = StringUtils.substring((String)subText, (int)1).split(NEWLINE, 2)[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nextLine != null && MarkdownParser.removeFromString(nextLine, NEWLINE, SPACE).isEmpty()) {
                    lastLineWasHeadline = false;
                    continue;
                }
                lastLineWasHeadline = false;
            }
            if (charsToSkip > 0) {
                --charsToSkip;
                continue;
            }
            if (c != '\n' && skipLine) continue;
            if (c == '\n' && skipLine) {
                builder.headlineType = MarkdownTextFragment.HeadlineType.NONE;
                builder.separationLine = false;
                skipLine = false;
                queueNewLine = true;
                continue;
            }
            if (parseMarkdown) {
                String hyperlink;
                String imageLink;
                List<String> hyperlinkImage;
                String s2;
                String s;
                if (isStartOfLine && c == '#' && builder.codeBlockContext == null && builder.headlineType == MarkdownTextFragment.HeadlineType.NONE) {
                    if (StringUtils.startsWith((CharSequence)subText, (CharSequence)HEADLINE_PREFIX_BIGGEST)) {
                        builder.headlineType = MarkdownTextFragment.HeadlineType.BIGGEST;
                        charsToSkip = 1;
                    }
                    if (StringUtils.startsWith((CharSequence)subText, (CharSequence)HEADLINE_PREFIX_BIGGER)) {
                        builder.headlineType = MarkdownTextFragment.HeadlineType.BIGGER;
                        charsToSkip = 2;
                    }
                    if (StringUtils.startsWith((CharSequence)subText, (CharSequence)HEADLINE_PREFIX_BIG)) {
                        builder.headlineType = MarkdownTextFragment.HeadlineType.BIG;
                        charsToSkip = 3;
                    }
                    if (builder.headlineType != MarkdownTextFragment.HeadlineType.NONE) {
                        lastLineWasHeadline = true;
                        continue;
                    }
                }
                if (c == '%') {
                    String fontName;
                    String afterPrefix;
                    if (StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_FONT_PREFIX) && !StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_FONT_SUFFIX) && builder.font == null && builder.codeBlockContext == null && StringUtils.contains((CharSequence)(afterPrefix = StringUtils.substring((String)subLine, (int)3)), (int)37) && RESOURCE_NAME_FILTER.isAllowedText(fontName = StringUtils.split((String)afterPrefix, (String)PERCENTAGE, (int)2)[0]) && StringUtils.contains((CharSequence)subText, (CharSequence)FORMATTING_CODE_FONT_SUFFIX)) {
                        ResourceLocation font = null;
                        try {
                            font = ResourceLocation.parse((String)fontName);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (font != null) {
                            if (isStartOfLine || !builder.text.isEmpty()) {
                                lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                            }
                            builder.font = font;
                            charsToSkip = fontName.length() + 3;
                            continue;
                        }
                    }
                    if (StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_FONT_SUFFIX) && builder.font != null) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.font = null;
                        charsToSkip = 3;
                        continue;
                    }
                }
                if (c == '%') {
                    if (StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_HEX_COLOR_PREFIX) && !StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_HEX_COLOR_SUFFIX) && builder.textColor == null && builder.codeBlockContext == null) {
                        DrawableColor color;
                        String s3;
                        String string = s3 = subLine.length() >= 11 ? StringUtils.substring((String)subLine, (int)1, (int)11) : EMPTY_STRING;
                        if (!StringUtils.endsWith((CharSequence)s3, (CharSequence)PERCENTAGE)) {
                            String string2 = s3 = subLine.length() >= 9 ? StringUtils.substring((String)subLine, (int)1, (int)9) : EMPTY_STRING;
                        }
                        if (StringUtils.endsWith((CharSequence)s3, (CharSequence)PERCENTAGE) && StringUtils.contains((CharSequence)subText, (CharSequence)FORMATTING_CODE_HEX_COLOR_SUFFIX) && (color = DrawableColor.of(StringUtils.substring((String)s3, (int)0, (int)(s3.length() - 1)))) != DrawableColor.EMPTY) {
                            if (isStartOfLine || !builder.text.isEmpty()) {
                                lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                            }
                            builder.textColor = color;
                            charsToSkip = s3.length();
                            continue;
                        }
                    }
                    if (StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_HEX_COLOR_SUFFIX) && builder.textColor != null) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.textColor = null;
                        charsToSkip = 2;
                        continue;
                    }
                }
                if (c == '*') {
                    if (!builder.bold && builder.codeBlockContext == null) {
                        String s22 = StringUtils.substring((String)markdownText, (int)Math.min(markdownText.length(), index + 2));
                        if (StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX) && StringUtils.contains((CharSequence)s22, (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX)) {
                            if (isStartOfLine || !builder.text.isEmpty()) {
                                lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                            }
                            builder.bold = true;
                            charsToSkip = 1;
                            continue;
                        }
                    }
                    if (builder.bold && StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX)) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.bold = false;
                        charsToSkip = 1;
                        continue;
                    }
                }
                int indexPlusOne = Math.min(markdownText.length(), index + 1);
                if (c == '_') {
                    if (!builder.italic && builder.codeBlockContext == null && StringUtils.contains((CharSequence)(s = StringUtils.substring((String)markdownText, (int)indexPlusOne)), (int)95)) {
                        if (isStartOfLine || !builder.text.isEmpty()) {
                            lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        }
                        builder.italic = true;
                        italicUnderscore = true;
                        continue;
                    }
                    if (builder.italic && italicUnderscore) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.italic = false;
                        italicUnderscore = false;
                        continue;
                    }
                }
                if (c == '*') {
                    if (!builder.italic && builder.codeBlockContext == null) {
                        s2 = StringUtils.substring((String)markdownText, (int)indexPlusOne);
                        if (!StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX) && StringUtils.contains((CharSequence)s2, (int)42)) {
                            boolean isEndSingleAsterisk = false;
                            int index2 = 0;
                            for (char c2 : s2.toCharArray()) {
                                String s3;
                                if (c2 == '*' && !StringUtils.startsWith((CharSequence)(s3 = StringUtils.substring((String)s2, (int)index2)), (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX)) {
                                    isEndSingleAsterisk = true;
                                    break;
                                }
                                ++index2;
                            }
                            if (isEndSingleAsterisk) {
                                if (isStartOfLine || !builder.text.isEmpty()) {
                                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                                }
                                builder.italic = true;
                                continue;
                            }
                        }
                    }
                    if (builder.italic && !italicUnderscore && !StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_BOLD_PREFIX_SUFFIX)) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.italic = false;
                        continue;
                    }
                }
                if (c == '~') {
                    if (!builder.strikethrough && builder.codeBlockContext == null && StringUtils.contains((CharSequence)(s = StringUtils.substring((String)markdownText, (int)indexPlusOne)), (int)126)) {
                        if (isStartOfLine || !builder.text.isEmpty()) {
                            lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        }
                        builder.strikethrough = true;
                        continue;
                    }
                    if (builder.strikethrough) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.strikethrough = false;
                        continue;
                    }
                }
                if (isStartOfLine && c == '[' && builder.codeBlockContext == null && StringUtils.startsWith((CharSequence)currentLine, (CharSequence)FORMATTING_CODE_HYPERLINK_IMAGE_PREFIX) && (hyperlinkImage = MarkdownParser.getHyperlinkImageFromLine(currentLine)) != null) {
                    builder.hyperlink = new MarkdownTextFragment.Hyperlink();
                    builder.hyperlink.link = hyperlinkImage.get(1);
                    MarkdownParser.setImageToBuilder(builder, hyperlinkImage.get(0));
                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(true, true));
                    builder.imageSupplier = null;
                    builder.hyperlink = null;
                    skipLine = true;
                    continue;
                }
                if (isStartOfLine && c == '!' && builder.codeBlockContext == null && StringUtils.startsWith((CharSequence)currentLine, (CharSequence)FORMATTING_CODE_IMAGE_PREFIX) && (imageLink = MarkdownParser.getImageFromLine(currentLine)) != null) {
                    MarkdownParser.setImageToBuilder(builder, imageLink);
                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(true, true));
                    builder.imageSupplier = null;
                    skipLine = true;
                    continue;
                }
                if (c == '[' && builder.hyperlink == null && builder.codeBlockContext == null && StringUtils.contains((CharSequence)(s2 = StringUtils.substring((String)markdownText, (int)indexPlusOne)), (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX) && StringUtils.contains((CharSequence)s2, (int)41) && (hyperlink = MarkdownParser.getHyperlinkFromLine(subText)) != null) {
                    if (isStartOfLine || !builder.text.isEmpty()) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                    }
                    builder.hyperlink = new MarkdownTextFragment.Hyperlink();
                    builder.hyperlink.link = hyperlink;
                    continue;
                }
                if (c == ']' && builder.hyperlink != null && StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX)) {
                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                    charsToSkip = 2 + builder.hyperlink.link.length();
                    builder.hyperlink = null;
                    continue;
                }
                if (isStartOfLine && c == '>' && builder.quoteContext == null && builder.codeBlockContext == null && StringUtils.startsWith((CharSequence)subText, (CharSequence)FORMATTING_CODE_QUOTE_PREFIX)) {
                    builder.quoteContext = new MarkdownTextFragment.QuoteContext();
                    charsToSkip = 1;
                    continue;
                }
                if (isStartOfLine && builder.quoteContext != null && StringUtils.trim((String)currentLine).isEmpty()) {
                    builder.quoteContext = null;
                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(true, true));
                    queueNewLine = true;
                    continue;
                }
                if (isStartOfLine && c == '-' && StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_BULLET_LIST_LEVEL_1_PREFIX) && !MarkdownParser.removeFromString(subLine, MINUS, SPACE, NEWLINE).isEmpty() && builder.codeBlockContext == null) {
                    builder.bulletListLevel = 1;
                    builder.bulletListItemStart = true;
                    charsToSkip = 1;
                    continue;
                }
                if (isStartOfLine && c == ' ' && StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_BULLET_LIST_LEVEL_2_PREFIX) && !MarkdownParser.removeFromString(subLine, MINUS, SPACE, NEWLINE).isEmpty() && builder.codeBlockContext == null) {
                    builder.bulletListLevel = 2;
                    builder.bulletListItemStart = true;
                    charsToSkip = 3;
                    continue;
                }
                if (isStartOfLine && c == '-' && builder.codeBlockContext == null && StringUtils.startsWith((CharSequence)currentLine, (CharSequence)FORMATTING_CODE_SEPARATION_LINE_PREFIX) && MINUS_CHARACTER_FILTER.isAllowedText(StringUtils.replace((String)currentLine, (String)SPACE, (String)EMPTY_STRING))) {
                    builder.separationLine = true;
                    builder.text = new StringBuilder(FORMATTING_CODE_SEPARATION_LINE_PREFIX);
                    lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(true, true));
                    skipLine = true;
                    continue;
                }
                if (c == '`') {
                    if (builder.codeBlockContext == null && !StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_CODE_BLOCK_MULTI_LINE_PREFIX_SUFFIX) && MarkdownParser.isFormattedBlock(subText, '`', true)) {
                        if (isStartOfLine || !builder.text.isEmpty()) {
                            lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        }
                        builder.codeBlockContext = new MarkdownTextFragment.CodeBlockContext();
                        builder.codeBlockContext.singleLine = true;
                        continue;
                    }
                    if (builder.codeBlockContext != null && builder.codeBlockContext.singleLine && !StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_CODE_BLOCK_MULTI_LINE_PREFIX_SUFFIX)) {
                        lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, false));
                        builder.codeBlockContext = null;
                        continue;
                    }
                }
                if (isStartOfLine && c == '`' && currentLine.length() == 3) {
                    if (builder.codeBlockContext == null && StringUtils.startsWith((CharSequence)currentLine, (CharSequence)FORMATTING_CODE_CODE_BLOCK_MULTI_LINE_PREFIX_SUFFIX) && MarkdownParser.isFormattedBlock(subText, '`', false)) {
                        builder.codeBlockContext = new MarkdownTextFragment.CodeBlockContext();
                        builder.codeBlockContext.singleLine = false;
                        skipLine = true;
                        continue;
                    }
                    if (builder.codeBlockContext != null && !builder.codeBlockContext.singleLine && StringUtils.startsWith((CharSequence)currentLine, (CharSequence)FORMATTING_CODE_CODE_BLOCK_MULTI_LINE_PREFIX_SUFFIX)) {
                        builder.codeBlockContext = null;
                        skipLine = true;
                        continue;
                    }
                }
                if (isStartOfLine && c == '^' && currentLine.length() == 3 && StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_ALIGNMENT_CENTERED_PREFIX_SUFFIX) && builder.codeBlockContext == null) {
                    if (builder.alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT && MarkdownParser.isFormattedBlock(subText, '^', false)) {
                        builder.alignment = MarkdownRenderer.MarkdownLineAlignment.CENTERED;
                        skipLine = true;
                        continue;
                    }
                    if (builder.alignment == MarkdownRenderer.MarkdownLineAlignment.CENTERED && MarkdownParser.removeFromString(subLine, CIRCUMFLEX, SPACE, NEWLINE).isEmpty()) {
                        builder.alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
                        skipLine = true;
                        continue;
                    }
                }
                if (isStartOfLine && c == '|' && currentLine.length() == 3 && StringUtils.startsWith((CharSequence)subLine, (CharSequence)FORMATTING_CODE_ALIGNMENT_RIGHT_PREFIX_SUFFIX) && builder.codeBlockContext == null) {
                    if (builder.alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT && MarkdownParser.isFormattedBlock(subText, '|', false)) {
                        builder.alignment = MarkdownRenderer.MarkdownLineAlignment.RIGHT;
                        skipLine = true;
                        continue;
                    }
                    if (builder.alignment == MarkdownRenderer.MarkdownLineAlignment.RIGHT && MarkdownParser.removeFromString(subLine, VERTICAL_BAR, SPACE, NEWLINE).isEmpty()) {
                        builder.alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
                        skipLine = true;
                        continue;
                    }
                }
            }
            if (c != '\n') {
                builder.text.append(c);
            }
            if (c == ' ') {
                if (!isStartOfLine && lastBuiltFragment != null && builder.text.toString().equals(SPACE)) {
                    lastBuiltFragment.endOfWord = true;
                    lastBuiltFragment.text = lastBuiltFragment.text + SPACE;
                    lastBuiltFragment.updateWidth();
                    builder.clearText();
                    continue;
                }
                lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(false, true));
                continue;
            }
            if (c != '\n') continue;
            lastBuiltFragment = MarkdownParser.addFragment(fragments, builder.build(true, true));
            builder.headlineType = MarkdownTextFragment.HeadlineType.NONE;
            builder.separationLine = false;
            builder.bulletListLevel = 0;
            queueNewLine = true;
        }
        fragments.add(builder.build(true, true));
        return fragments;
    }

    protected static String removeFromString(@NotNull String in, String ... remove) {
        for (String s : remove) {
            in = StringUtils.replace((String)in, (String)s, (String)EMPTY_STRING);
        }
        return in;
    }

    protected static MarkdownTextFragment addFragment(List<MarkdownTextFragment> fragments, MarkdownTextFragment fragment) {
        fragments.add(fragment);
        return fragment;
    }

    protected static void setImageToBuilder(@NotNull FragmentBuilder builder, @NotNull String imageSource) {
        builder.imageSupplier = ResourceSupplier.image(imageSource);
    }

    @NotNull
    protected static String getLine(@NotNull String text) {
        try {
            if (!StringUtils.contains((CharSequence)text, (CharSequence)NEWLINE)) {
                return text;
            }
            if (StringUtils.startsWith((CharSequence)text, (CharSequence)NEWLINE)) {
                return EMPTY_STRING;
            }
            return StringUtils.split((String)text, (String)NEWLINE, (int)2)[0];
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get line of Markdown text!", (Throwable)ex);
            return text;
        }
    }

    protected static boolean isFormattedBlock(String text, char formatChar, boolean singleLine) {
        String longFormatCode = EMPTY_STRING + formatChar + formatChar + formatChar;
        if (singleLine) {
            if (StringUtils.startsWith((CharSequence)text, (CharSequence)(EMPTY_STRING + formatChar)) && !StringUtils.startsWith((CharSequence)text, (CharSequence)longFormatCode)) {
                int i = -1;
                boolean endFound = false;
                for (char c : text.toCharArray()) {
                    if (++i == 0) continue;
                    if (c == '\n') break;
                    if (c != formatChar || StringUtils.startsWith((CharSequence)StringUtils.substring((String)text, (int)i), (CharSequence)(EMPTY_STRING + formatChar + formatChar + formatChar))) continue;
                    endFound = true;
                    break;
                }
                return endFound;
            }
        } else if (StringUtils.startsWith((CharSequence)text, (CharSequence)longFormatCode)) {
            int i = -1;
            boolean endFound = false;
            boolean newLine = false;
            for (char c : text.toCharArray()) {
                if (++i < 3) continue;
                if (c == formatChar && newLine && StringUtils.startsWith((CharSequence)StringUtils.substring((String)text, (int)i), (CharSequence)longFormatCode)) {
                    endFound = true;
                    break;
                }
                if (newLine) {
                    newLine = false;
                }
                if (c != '\n') continue;
                newLine = true;
            }
            return endFound;
        }
        return false;
    }

    @Nullable
    protected static List<String> getHyperlinkImageFromLine(String line) {
        if (StringUtils.startsWith((CharSequence)line, (CharSequence)FORMATTING_CODE_HYPERLINK_IMAGE_PREFIX) && StringUtils.contains((CharSequence)line, (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX) && StringUtils.contains((CharSequence)line, (int)41)) {
            String imageLink = null;
            String hyperLink = null;
            int index = -1;
            for (char ignored : line.toCharArray()) {
                String sub = StringUtils.substring((String)line, (int)(++index));
                if (index < 1 || !StringUtils.startsWith((CharSequence)sub, (CharSequence)FORMATTING_CODE_IMAGE_PREFIX) || (imageLink = MarkdownParser.getImageFromLine(sub)) == null) continue;
                String s = StringUtils.split((String)sub, (String)CLOSE_ROUND_BRACKETS, (int)2)[0] + CLOSE_ROUND_BRACKETS;
                hyperLink = MarkdownParser.getHyperlinkFromLine(line.replace(s, EMPTY_STRING));
                break;
            }
            if (imageLink != null && hyperLink != null) {
                return ListUtils.of(imageLink, hyperLink);
            }
        }
        return null;
    }

    @Nullable
    protected static String getImageFromLine(String line) {
        if (StringUtils.startsWith((CharSequence)line, (CharSequence)FORMATTING_CODE_IMAGE_PREFIX) && StringUtils.contains((CharSequence)line, (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX) && StringUtils.contains((CharSequence)line, (CharSequence)CLOSE_ROUND_BRACKETS)) {
            boolean beforeClosedBrackets = true;
            boolean isInsideImageLink = false;
            StringBuilder imageLink = new StringBuilder();
            boolean openRoundBracketsFound = false;
            String s = StringUtils.substring((String)line, (int)2);
            int index = -1;
            for (char c : s.toCharArray()) {
                ++index;
                if (c == '\n') {
                    return null;
                }
                if (c == ']') {
                    if (!beforeClosedBrackets) {
                        return null;
                    }
                    beforeClosedBrackets = false;
                    if (StringUtils.startsWith((CharSequence)StringUtils.substring((String)s, (int)index), (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX)) {
                        isInsideImageLink = true;
                        continue;
                    }
                }
                if (c == '[' && beforeClosedBrackets) {
                    return null;
                }
                if (!isInsideImageLink) continue;
                if (c == '(') {
                    if (!openRoundBracketsFound) {
                        openRoundBracketsFound = true;
                        continue;
                    }
                    return null;
                }
                if (c == ')') {
                    return imageLink.toString();
                }
                imageLink.append(c);
            }
        }
        return null;
    }

    @Nullable
    protected static String getHyperlinkFromLine(String line) {
        if (StringUtils.startsWith((CharSequence)line, (CharSequence)OPEN_SQUARE_BRACKETS) && StringUtils.contains((CharSequence)line, (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX) && StringUtils.contains((CharSequence)line, (CharSequence)CLOSE_ROUND_BRACKETS)) {
            boolean beforeClosedBrackets = true;
            boolean isInsideHyperlink = false;
            StringBuilder hyperlink = new StringBuilder();
            boolean openRoundBracketsFound = false;
            String s = StringUtils.substring((String)line, (int)1);
            int index = -1;
            for (char c : s.toCharArray()) {
                ++index;
                if (c == '\n') {
                    return null;
                }
                if (c == ']') {
                    if (!beforeClosedBrackets) {
                        return null;
                    }
                    beforeClosedBrackets = false;
                    if (StringUtils.startsWith((CharSequence)StringUtils.substring((String)s, (int)index), (CharSequence)FORMATTING_CODE_HYPERLINK_INNER_PREFIX)) {
                        isInsideHyperlink = true;
                        continue;
                    }
                }
                if (c == '[' && beforeClosedBrackets) {
                    return null;
                }
                if (!isInsideHyperlink) continue;
                if (c == '(') {
                    if (!openRoundBracketsFound) {
                        openRoundBracketsFound = true;
                        continue;
                    }
                    return null;
                }
                if (c == ')') {
                    return hyperlink.toString();
                }
                hyperlink.append(c);
            }
        }
        return null;
    }

    protected static class FragmentBuilder {
        protected final MarkdownRenderer renderer;
        protected StringBuilder text = new StringBuilder();
        protected DrawableColor textColor = null;
        protected ResourceSupplier<ITexture> imageSupplier = null;
        protected boolean separationLine = false;
        protected boolean bold = false;
        protected boolean italic = false;
        protected boolean strikethrough = false;
        protected boolean bulletListItemStart = false;
        protected int bulletListLevel = 0;
        @NotNull
        protected MarkdownRenderer.MarkdownLineAlignment alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
        protected MarkdownTextFragment.Hyperlink hyperlink = null;
        @NotNull
        protected MarkdownTextFragment.HeadlineType headlineType = MarkdownTextFragment.HeadlineType.NONE;
        protected MarkdownTextFragment.QuoteContext quoteContext = null;
        protected MarkdownTextFragment.CodeBlockContext codeBlockContext = null;
        protected ResourceLocation font = null;

        protected FragmentBuilder(MarkdownRenderer renderer) {
            this.renderer = renderer;
        }

        @NotNull
        protected MarkdownTextFragment build(boolean naturalLineBreakAfter, boolean endOfWord) {
            MarkdownTextFragment frag = new MarkdownTextFragment(this.renderer, this.text.toString());
            frag.font = this.font;
            frag.textColor = this.textColor;
            frag.imageSupplier = this.imageSupplier;
            frag.separationLine = this.separationLine;
            if (this.separationLine) {
                frag.unscaledTextHeight = 1.0f;
            }
            frag.bold = this.bold;
            frag.italic = this.italic;
            frag.strikethrough = this.strikethrough;
            frag.bulletListLevel = this.bulletListLevel;
            frag.bulletListItemStart = this.bulletListItemStart;
            this.bulletListItemStart = false;
            frag.alignment = this.alignment;
            frag.hyperlink = this.hyperlink;
            if (this.hyperlink != null) {
                this.hyperlink.hyperlinkFragments.add(frag);
            }
            frag.headlineType = this.headlineType;
            frag.quoteContext = this.quoteContext;
            if (this.quoteContext != null) {
                this.quoteContext.quoteFragments.add(frag);
            }
            frag.codeBlockContext = this.codeBlockContext;
            if (this.codeBlockContext != null) {
                this.codeBlockContext.codeBlockFragments.add(frag);
            }
            frag.naturalLineBreakAfter = naturalLineBreakAfter;
            frag.endOfWord = endOfWord;
            frag.updateWidth();
            this.clearText();
            return frag;
        }

        protected FragmentBuilder clearText() {
            this.text = new StringBuilder();
            return this;
        }
    }
}

