/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinGameRenderer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.FastColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final ResourceLocation FULLY_TRANSPARENT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/fully_transparent.png");
    public static final ResourceLocation BLUR_LOCATION = ResourceLocation.parse((String)"shaders/post/blur.json");
    public static PostChain blurEffect = null;

    public static void renderBlurredArea(GuiGraphics graphics, int x, int y, int width, int height, float partialTicks, int blurRadius) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.backupProjectionMatrix();
        int margin = blurRadius * 2;
        int captureX = x - margin;
        int captureY = y - margin;
        int captureWidth = width + margin * 2;
        int captureHeight = height + margin * 2;
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        captureX = Math.max(0, captureX);
        captureY = Math.max(0, captureY);
        captureWidth = Math.min(captureWidth, screenWidth - captureX);
        captureHeight = Math.min(captureHeight, screenHeight - captureY);
        TextureTarget blurRenderTarget = new TextureTarget(captureWidth, captureHeight, true, Minecraft.ON_OSX);
        blurRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        blurRenderTarget.clear(true);
        blurRenderTarget.bindWrite(true);
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)captureWidth, (float)captureHeight, 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderTexture((int)0, (int)minecraft.getMainRenderTarget().getColorTextureId());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float u0 = (float)captureX / (float)screenWidth;
        float v0 = (float)captureY / (float)screenHeight;
        float u1 = (float)(captureX + captureWidth) / (float)screenWidth;
        float v1 = (float)(captureY + captureHeight) / (float)screenHeight;
        bufferBuilder.addVertex(0.0f, (float)captureHeight, 0.0f).setUv(u0, v1);
        bufferBuilder.addVertex((float)captureWidth, (float)captureHeight, 0.0f).setUv(u1, v1);
        bufferBuilder.addVertex((float)captureWidth, 0.0f, 0.0f).setUv(u1, v0);
        bufferBuilder.addVertex(0.0f, 0.0f, 0.0f).setUv(u0, v0);
        MeshData meshData = bufferBuilder.buildOrThrow();
        BufferUploader.drawWithShader((MeshData)meshData);
        PostChain blurEffect = ((IMixinGameRenderer)Minecraft.getInstance().gameRenderer).getBlurEffect_FancyMenu();
        if (blurEffect != null) {
            blurEffect.resize(captureWidth, captureHeight);
            blurEffect.setUniform("Radius", (float)blurRadius);
            blurEffect.process(partialTicks);
        }
        blurRenderTarget.unbindWrite();
        Window window = minecraft.getWindow();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)window.getGuiScaledWidth(), (float)window.getGuiScaledHeight(), 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.applyModelViewMatrix();
        minecraft.getMainRenderTarget().bindWrite(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (int)blurRenderTarget.getColorTextureId());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float texU0 = (float)margin / (float)captureWidth;
        float texV0 = (float)margin / (float)captureHeight;
        float texU1 = (float)(margin + width) / (float)captureWidth;
        float texV1 = (float)(margin + height) / (float)captureHeight;
        bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        Matrix4f screenMatrix = poseStack.last().pose();
        bufferBuilder.addVertex(screenMatrix, 0.0f, (float)height, 0.0f).setUv(texU0, texV1);
        bufferBuilder.addVertex(screenMatrix, (float)width, (float)height, 0.0f).setUv(texU1, texV1);
        bufferBuilder.addVertex(screenMatrix, (float)width, 0.0f, 0.0f).setUv(texU1, texV0);
        bufferBuilder.addVertex(screenMatrix, 0.0f, 0.0f, 0.0f).setUv(texU0, texV0);
        MeshData screenMeshData = bufferBuilder.buildOrThrow();
        BufferUploader.drawWithShader((MeshData)screenMeshData);
        poseStack.popPose();
        RenderSystem.disableBlend();
        blurRenderTarget.destroyBuffers();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    @ApiStatus.Experimental
    public static void processBlurEffect(@NotNull GuiGraphics graphics, int x, int y, int width, int height, float partial, float blurriness) {
        if (blurEffect == null) {
            RenderingUtils.reloadBlurShader();
        }
        RenderSystem.enableBlend();
        float _blurriness = blurriness * 10.0f;
        if (blurEffect != null && _blurriness >= 1.0f) {
            graphics.enableScissor(x, y, x + width, y + height);
            blurEffect.setUniform("Radius", _blurriness);
            blurEffect.process(partial);
            graphics.disableScissor();
        }
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        RenderSystem.disableBlend();
    }

    @ApiStatus.Experimental
    public static void reloadBlurShader() {
        if (blurEffect != null) {
            blurEffect.close();
        }
        try {
            GameRenderer.ResourceCache cache = new GameRenderer.ResourceCache((ResourceProvider)Minecraft.getInstance().getResourceManager(), new HashMap());
            blurEffect = new PostChain(Minecraft.getInstance().getTextureManager(), (ResourceProvider)cache, Minecraft.getInstance().getMainRenderTarget(), BLUR_LOCATION);
            blurEffect.resize(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to load shader: {}", (Object)BLUR_LOCATION, (Object)ex);
        }
        catch (JsonSyntaxException var4) {
            LOGGER.warn("Failed to parse shader: {}", (Object)BLUR_LOCATION, (Object)var4);
        }
    }

    public static void renderMissing(@NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.fill(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.fill(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.fill(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.fill(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void blitRepeat(@NotNull GuiGraphics graphics, @NotNull ResourceLocation location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        graphics.blit(location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight);
    }

    public static void blitRepeat(@NotNull GuiGraphics graphics, @NotNull ResourceLocation location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texRenderWidth, int texRenderHeight, int texOffsetX, int texOffsetY, int texPartWidth, int texPartHeight, int texWidth, int texHeight) {
        int repeatsVertical;
        Objects.requireNonNull(graphics);
        Objects.requireNonNull(location);
        if (areaRenderWidth <= 0 || areaRenderHeight <= 0 || texRenderWidth <= 0 || texRenderHeight <= 0 || texPartWidth <= 0 || texPartHeight <= 0) {
            return;
        }
        int repeatsHorizontal = Math.max(1, areaRenderWidth / texPartWidth);
        if (texPartWidth * repeatsHorizontal < areaRenderWidth) {
            ++repeatsHorizontal;
        }
        if (texPartHeight * (repeatsVertical = Math.max(1, areaRenderHeight / texPartHeight)) < areaRenderHeight) {
            ++repeatsVertical;
        }
        graphics.enableScissor(x, y, x + areaRenderWidth, y + areaRenderHeight);
        for (int horizontal = 0; horizontal < repeatsHorizontal; ++horizontal) {
            for (int vertical = 0; vertical < repeatsVertical; ++vertical) {
                int renderX = x + texPartWidth * horizontal;
                int renderY = y + texPartHeight * vertical;
                graphics.blit(location, renderX, renderY, texRenderWidth, texRenderHeight, (float)texOffsetX, (float)texOffsetY, texPartWidth, texPartHeight, texWidth, texHeight);
            }
        }
        graphics.disableScissor();
    }

    public static void blitNineSliced(@NotNull GuiGraphics graphics, @NotNull ResourceLocation location, int x, int y, int renderWidth, int renderHeight, int borderLeft, int borderTop, int borderRight, int borderBottom, int texPartWidth, int texPartHeight, int texOffsetX, int texOffsetY, int texWidth, int texHeight) {
        Objects.requireNonNull(graphics);
        Objects.requireNonNull(location);
        if (renderWidth <= 0 || renderHeight <= 0 || texPartWidth <= 0 || texPartHeight <= 0 || texWidth <= 0 || texHeight <= 0) {
            return;
        }
        if (renderWidth == texWidth && renderHeight == texHeight && texOffsetX == 0 && texOffsetY == 0) {
            graphics.blit(location, x, y, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
            return;
        }
        graphics.enableScissor(x, y, x + renderWidth, y + renderHeight);
        if (borderLeft > 0 && borderTop > 0) {
            graphics.blit(location, x, y, borderLeft, borderTop, (float)texOffsetX, (float)texOffsetY, borderLeft, borderTop, texWidth, texHeight);
        }
        if (borderRight > 0 && borderTop > 0) {
            graphics.blit(location, x + renderWidth - borderRight, y, borderRight, borderTop, (float)(texOffsetX + texPartWidth - borderRight), (float)texOffsetY, borderRight, borderTop, texWidth, texHeight);
        }
        if (borderLeft > 0 && borderBottom > 0) {
            graphics.blit(location, x, y + renderHeight - borderBottom, borderLeft, borderBottom, (float)texOffsetX, (float)(texOffsetY + texPartHeight - borderBottom), borderLeft, borderBottom, texWidth, texHeight);
        }
        if (borderRight > 0 && borderBottom > 0) {
            graphics.blit(location, x + renderWidth - borderRight, y + renderHeight - borderBottom, borderRight, borderBottom, (float)(texOffsetX + texPartWidth - borderRight), (float)(texOffsetY + texPartHeight - borderBottom), borderRight, borderBottom, texWidth, texHeight);
        }
        graphics.disableScissor();
        if (borderTop > 0) {
            RenderingUtils.blitRepeat(graphics, location, x + borderLeft, y, renderWidth - borderLeft - borderRight, borderTop, texPartWidth - borderLeft - borderRight, borderTop, texOffsetX + borderLeft, texOffsetY, texPartWidth - borderLeft - borderRight, borderTop, texWidth, texHeight);
        }
        if (borderBottom > 0) {
            RenderingUtils.blitRepeat(graphics, location, x + borderLeft, y + renderHeight - borderBottom, renderWidth - borderLeft - borderRight, borderBottom, texPartWidth - borderLeft - borderRight, borderBottom, texOffsetX + borderLeft, texOffsetY + texPartHeight - borderBottom, texPartWidth - borderLeft - borderRight, borderBottom, texWidth, texHeight);
        }
        if (borderLeft > 0) {
            RenderingUtils.blitRepeat(graphics, location, x, y + borderTop, borderLeft, renderHeight - borderTop - borderBottom, borderLeft, texPartHeight - borderTop - borderBottom, texOffsetX, texOffsetY + borderTop, borderLeft, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
        }
        if (borderRight > 0) {
            RenderingUtils.blitRepeat(graphics, location, x + renderWidth - borderRight, y + borderTop, borderRight, renderHeight - borderTop - borderBottom, borderRight, texPartHeight - borderTop - borderBottom, texOffsetX + texPartWidth - borderRight, texOffsetY + borderTop, borderRight, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
        }
        RenderingUtils.blitRepeat(graphics, location, x + borderLeft, y + borderTop, renderWidth - borderLeft - borderRight, renderHeight - borderTop - borderBottom, texPartWidth - borderLeft - borderRight, texPartHeight - borderTop - borderBottom, texOffsetX + borderLeft, texOffsetY + borderTop, texPartWidth - borderLeft - borderRight, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
    }

    public static float getPartialTick() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        Window m = Minecraft.getInstance().getWindow();
        m.setGuiScale((double)m.calculateScale(((Integer)Minecraft.getInstance().options.guiScale().get()).intValue(), ((Boolean)Minecraft.getInstance().options.forceUnicodeFont().get()).booleanValue()));
    }

    public static void resetShaderColor(GuiGraphics graphics) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(graphics, color, a);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        graphics.setColor(r, g, b, alpha);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = graphics.pose().last().pose();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferBuilder.addVertex(matrix4f, minX, minY, z).setColor(red, green, blue, alpha);
        bufferBuilder.addVertex(matrix4f, minX, maxY, z).setColor(red, green, blue, alpha);
        bufferBuilder.addVertex(matrix4f, maxX, maxY, z).setColor(red, green, blue, alpha);
        bufferBuilder.addVertex(matrix4f, maxX, minY, z).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(bufferBuilder.build()));
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull GuiGraphics graphics, ResourceLocation location, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(GuiGraphics $$0, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, location, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(GuiGraphics graphics, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit(graphics, location, $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(GuiGraphics graphics, ResourceLocation location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f $$10 = graphics.pose().last().pose();
        BufferBuilder $$11 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        $$11.addVertex($$10, $$1, $$3, $$5).setUv($$6, $$8);
        $$11.addVertex($$10, $$1, $$4, $$5).setUv($$6, $$9);
        $$11.addVertex($$10, $$2, $$4, $$5).setUv($$7, $$9);
        $$11.addVertex($$10, $$2, $$3, $$5).setUv($$7, $$8);
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull($$11.build()));
    }
}

