/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinServerList;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinServerAction
extends Action {
    public JoinServerAction() {
        super("joinserver");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            Screen current;
            String ip = value.replace(" ", "");
            int port = 25565;
            if (ip.contains(":")) {
                String portString = ip.split(":", 2)[1];
                ip = ip.split(":", 2)[0];
                if (MathUtils.isInteger((String)portString)) {
                    port = Integer.parseInt(portString);
                }
            }
            ServerData d = null;
            ServerList l = new ServerList(Minecraft.getInstance());
            l.load();
            for (ServerData data : ((IMixinServerList)l).getServerListFancyMenu()) {
                if (!data.ip.equals(value.replace(" ", ""))) continue;
                d = data;
                break;
            }
            if (d == null) {
                d = new ServerData(value.replace(" ", ""), value.replace(" ", ""), ServerData.Type.OTHER);
                l.add(d, false);
                l.save();
            }
            if ((current = Minecraft.getInstance().screen) == null) {
                current = new TitleScreen();
            }
            boolean isQuickPlay = false;
            ConnectScreen.startConnecting((Screen)current, (Minecraft)Minecraft.getInstance(), (ServerAddress)new ServerAddress(ip, port), (ServerData)d, (boolean)isQuickPlay, null);
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.editor.custombutton.config.actiontype.joinserver");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.joinserver.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.translatable((String)"fancymenu.editor.custombutton.config.actiontype.joinserver.desc.value");
    }

    @Override
    public String getValueExample() {
        return "exampleserver.com:25565";
    }
}

