/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;
import xaero.map.gui.CursorBox;
import xaero.map.gui.ICanTooltip;
import xaero.map.gui.IScreenBase;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.misc.Misc;

public class ScreenBase
extends Screen
implements IScreenBase {
    public Screen parent;
    public Screen escape;
    protected boolean canSkipWorldRender;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;

    protected ScreenBase(Screen parent, Screen escape, Component titleIn) {
        super(titleIn);
        this.parent = parent;
        this.escape = escape;
        this.canSkipWorldRender = true;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    protected void onExit(Screen screen) {
        this.minecraft.setScreen(screen);
    }

    protected void goBack() {
        this.onExit(this.parent);
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    public void renderEscapeScreen(GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.render(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        GlStateManager._clear((int)256, (boolean)Minecraft.ON_OSX);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        PoseStack poseStack = guiGraphics.pose();
        this.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.render(guiGraphics, mouseX, mouseY, partial);
        }
        if (this.openDropdown != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 2.0f);
            this.openDropdown.render(guiGraphics, mouseX, mouseY, this.height, false);
            poseStack.popPose();
        }
    }

    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
    }

    protected void init() {
        super.init();
        this.dropdowns.clear();
        this.openDropdown = null;
        if (this.escape != null) {
            this.escape.init(this.minecraft, this.width, this.height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.mouseClicked(mouseX, mouseY, button);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double g, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                return this.openDropdown.mouseScrolled(mouseX, mouseY, g, wheel);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, g, wheel);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null && this.openDropdown.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && Misc.screenShouldSkipWorldRender(this.escape, true);
    }

    protected boolean renderTooltips(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 2.1);
        boolean result = false;
        boolean mousePressed = GLFW.glfwGetMouseButton((long)this.minecraft.getWindow().getWindow(), (int)0) == 1;
        for (GuiEventListener el : this.children()) {
            CursorBox tooltip;
            AbstractWidget b;
            if (!(el instanceof AbstractWidget) || !((b = (AbstractWidget)el) instanceof ICanTooltip) || b instanceof AbstractSliderButton && mousePressed) continue;
            ICanTooltip canTooltip = (ICanTooltip)b;
            if (par1 < b.getX() || par2 < b.getY() || par1 >= b.getX() + b.getWidth() || par2 >= b.getY() + b.getHeight() || canTooltip.getXaero_wm_tooltip() == null || (tooltip = canTooltip.getXaero_wm_tooltip().get()) == null) continue;
            tooltip.drawBox(guiGraphics, par1, par2, this.width, this.height);
            result = true;
            break;
        }
        matrixStack.popPose();
        return result;
    }

    public Screen getEscape() {
        return this.escape;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected <T extends GuiEventListener & NarratableEntry> T addWidget(T guiEventListener) {
        if (guiEventListener instanceof DropDownWidget) {
            this.dropdowns.add((DropDownWidget)guiEventListener);
        }
        return (T)super.addWidget(guiEventListener);
    }

    private void handleDropdownReplacement(AbstractWidget current, AbstractWidget replacement) {
        int dropdownIndex = this.dropdowns.indexOf(current);
        if (dropdownIndex != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
        if (this.getFocused() == current) {
            this.setFocused((GuiEventListener)replacement);
        }
    }

    private void replaceWidget(AbstractWidget current, AbstractWidget replacement, boolean renderable) {
        int childIndex = this.children().indexOf(current);
        if (childIndex != -1) {
            super.removeWidget((GuiEventListener)current);
            if (renderable) {
                super.addRenderableWidget((GuiEventListener)replacement);
            } else {
                super.addWidget((GuiEventListener)replacement);
            }
            this.children().remove(replacement);
            this.children().add(childIndex, replacement);
        }
        this.handleDropdownReplacement(current, replacement);
    }

    public void replaceWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, false);
    }

    public void replaceRenderableWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, true);
    }

    protected void removeWidget(GuiEventListener current) {
        this.dropdowns.remove(current);
        super.removeWidget(current);
    }
}

