/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class StonecutterRecipeContainer {
    private static final String DATA_SELECTED_RECIPE_INDEX = "selectedRecipeIndex";
    private final Slot inputSlot;
    private final IServerUpdater serverUpdater;
    private final Level level;
    private final Slot outputSlot;
    private final ResultContainer resultInventory = new ResultContainer();
    private List<RecipeHolder<StonecutterRecipe>> recipes = Lists.newArrayList();
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private Item inputItem = Items.AIR;
    private final CraftingItemHandler inputInventory;
    private Runnable inventoryUpdateListener = () -> {};
    private final Supplier<Optional<ResourceLocation>> getLastSelectedRecipeId;
    private final Consumer<ResourceLocation> setLastSelectedRecipeId;
    private long lastOnTake = -1L;

    public StonecutterRecipeContainer(StonecutterUpgradeContainer upgradeContainer, Consumer<Slot> addSlot, IServerUpdater serverUpdater, ContainerLevelAccess worldPosCallable, Level level) {
        this.inputSlot = new SlotSuppliedHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, 0, -1, -1){

            public void setChanged() {
                super.setChanged();
                StonecutterRecipeContainer.this.onCraftMatrixChanged((Container)StonecutterRecipeContainer.this.inputInventory);
            }

            public ItemStack remove(int amount) {
                ItemStack ret = super.remove(amount);
                if (this.getItem().isEmpty()) {
                    this.setChanged();
                }
                return ret;
            }
        };
        this.serverUpdater = serverUpdater;
        this.level = level;
        addSlot.accept(this.inputSlot);
        this.inputInventory = new CraftingItemHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, this::onCraftMatrixChanged);
        this.outputSlot = new ResultSlot(worldPosCallable);
        addSlot.accept(this.outputSlot);
        this.getLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getRecipeId;
        this.setLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::setRecipeId;
        this.onCraftMatrixChanged((Container)this.inputInventory);
    }

    private void onCraftMatrixChanged(Container inventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (itemstack.getItem() != this.inputItem) {
            this.inputItem = itemstack.getItem();
            this.updateAvailableRecipes(inventory, itemstack);
        }
        this.inventoryUpdateListener.run();
    }

    private void updateAvailableRecipes(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.set(-1);
        this.outputSlot.set(ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            this.recipes = RecipeHelper.getRecipesOfType(RecipeType.STONECUTTING, new SingleRecipeInput(inventory.getItem(0)));
            this.getLastSelectedRecipeId.get().ifPresent(id -> {
                for (int i = 0; i < this.recipes.size(); ++i) {
                    if (!this.recipes.get(i).id().equals(id)) continue;
                    this.selectedRecipe.set(i);
                    this.updateRecipeResultSlot();
                }
            });
        }
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public List<RecipeHolder<StonecutterRecipe>> getRecipeList() {
        return this.recipes;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean selectRecipe(int recipeIndex) {
        if (this.isIndexInRecipeBounds(recipeIndex)) {
            this.selectedRecipe.set(recipeIndex);
            this.setLastSelectedRecipeId.accept(this.recipes.get(recipeIndex).id());
            this.updateRecipeResultSlot();
            this.serverUpdater.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), DATA_SELECTED_RECIPE_INDEX, recipeIndex));
        }
        return true;
    }

    private boolean isIndexInRecipeBounds(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isIndexInRecipeBounds(this.selectedRecipe.get())) {
            RecipeHolder<StonecutterRecipe> stonecuttingrecipe = this.recipes.get(this.selectedRecipe.get());
            this.resultInventory.setRecipeUsed(stonecuttingrecipe);
            this.outputSlot.set(((StonecutterRecipe)stonecuttingrecipe.value()).assemble(new SingleRecipeInput(this.inputInventory.getItem(0)), (HolderLookup.Provider)this.level.registryAccess()));
        } else {
            this.outputSlot.set(ItemStack.EMPTY);
        }
    }

    public void handlePacket(CompoundTag data) {
        if (data.contains(DATA_SELECTED_RECIPE_INDEX)) {
            this.selectRecipe(data.getInt(DATA_SELECTED_RECIPE_INDEX));
        }
    }

    public boolean isNotResultSlot(Slot slot) {
        return slot != this.outputSlot;
    }

    private class ResultSlot
    extends Slot {
        private final ContainerLevelAccess worldPosCallable;

        public ResultSlot(ContainerLevelAccess worldPosCallable) {
            super((Container)StonecutterRecipeContainer.this.resultInventory, 1, -1, -1);
            this.worldPosCallable = worldPosCallable;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public void onTake(Player player, ItemStack stack) {
            stack.onCraftedBy(player.level(), player, stack.getCount());
            StonecutterRecipeContainer.this.resultInventory.awardUsedRecipes(player, List.of(StonecutterRecipeContainer.this.inputSlot.getItem()));
            ItemStack itemstack = StonecutterRecipeContainer.this.inputSlot.remove(1);
            if (!itemstack.isEmpty()) {
                StonecutterRecipeContainer.this.updateRecipeResultSlot();
            }
            this.worldPosCallable.execute((world, pos) -> {
                long l = world.getGameTime();
                if (StonecutterRecipeContainer.this.lastOnTake != l) {
                    world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    StonecutterRecipeContainer.this.lastOnTake = l;
                }
            });
            super.onTake(player, stack);
        }
    }
}

