/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove.forge;

import java.io.File;
import java.lang.reflect.Field;
import java.security.CodeSource;
import java.util.List;
import java.util.Optional;
import me.pieking1215.invmove.InvMove;
import me.pieking1215.invmove.InvMove21;
import me.pieking1215.invmove.InvMoveConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.ArrayUtils;

public class InvMoveForgeClient {
    static void finishInit() {
        InvMove.instance().finishInit();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGUIDrawPost(ScreenEvent.Render.Post event) {
        InvMove.instance().drawDebugOverlay();
    }

    static void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new InvMoveForgeClient());
        Field modClassesField = null;
        try {
            modClassesField = FMLModContainer.class.getDeclaredField("modClasses");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        final Field modClassesFieldFinal = modClassesField;
        InvMove.setInstance(new InvMove21(){

            @Override
            protected Optional<String> modidFromClassInternal(Class<?> c) {
                if (c.getPackage().getName().startsWith("net.minecraft.")) {
                    return Optional.of("minecraft");
                }
                return ModList.get().applyForEachModContainer(mod -> {
                    if (mod instanceof FMLModContainer) {
                        FMLModContainer fmlMod = (FMLModContainer)mod;
                        if (modClassesFieldFinal != null) {
                            boolean eq;
                            CodeSource src1 = c.getProtectionDomain().getCodeSource();
                            CodeSource src2 = null;
                            try {
                                src2 = ((Class)((List)modClassesFieldFinal.get(fmlMod)).getFirst()).getProtectionDomain().getCodeSource();
                            }
                            catch (IllegalAccessException e) {
                                return Optional.empty();
                            }
                            boolean bl = eq = src1 != null && src2 != null && src1.getLocation().equals(src2.getLocation());
                            if (eq) {
                                return Optional.of(mod.getModId());
                            }
                        }
                    }
                    return Optional.empty();
                }).filter(Optional::isPresent).map(Optional::get).findFirst();
            }

            @Override
            public String modNameFromModid(String modid) {
                return ModList.get().getModContainerById(modid).map(con -> con.getModInfo().getDisplayName()).orElse(modid);
            }

            @Override
            public boolean hasMod(String modid) {
                return ModList.get().isLoaded(modid);
            }

            @Override
            public File configDir() {
                return FMLPaths.CONFIGDIR.get().toFile();
            }

            @Override
            protected void registerKeybind(KeyMapping key) {
                key.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.UNIVERSAL);
                Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.getInstance().options.keyMappings, (Object)key);
            }
        });
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, screen) -> InvMoveConfig.setupCloth(screen));
    }
}

