/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule16;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class InvMove {
    private static InvMove instance;
    public static final String MOD_ID = "invmove";
    private static final KeyMapping TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    private final HashMap<Class<?>, Optional<String>> modidFromClassCache = new HashMap();
    protected boolean wasSneaking = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<ToggleKeyMapping, Boolean> wasToggleKeyDown = new HashMap<ToggleKeyMapping, Boolean>();
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        System.out.println("[InvMove] Registered Module: " + String.valueOf(module));
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    protected abstract Optional<String> modidFromClassInternal(Class<?> var1);

    public Optional<String> modidFromClass(Class<?> c) {
        return this.modidFromClassCache.computeIfAbsent(c, this::modidFromClassInternal);
    }

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(KeyMapping var1);

    public abstract MutableComponent translatableComponent(String var1);

    public abstract MutableComponent literalComponent(String var1);

    public MutableComponent fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public abstract boolean optionToggleCrouch();

    public abstract void setOptionToggleCrouch(boolean var1);

    protected abstract void drawShadow(Font var1, PoseStack var2, String var3, float var4, float var5, int var6);

    public abstract ResourceLocation parseResource(String var1);

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule16();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(Screen screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.isUnbound()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.setDown(InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)InvMove.TOGGLE_MOVEMENT_KEY.key.getValue()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.isDown;
        if (InvMove.TOGGLE_MOVEMENT_KEY.isDown && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    public void onInputUpdate(Input input) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (input.getClass() != KeyboardInput.class || input != Minecraft.getInstance().player.input) {
            return;
        }
        if (Minecraft.getInstance().screen == null) {
            this.wasSneaking = input.shiftKeyDown;
        }
        boolean canMove = this.allowMovementInScreen(Minecraft.getInstance().screen);
        if (canMove = this.handleToggleMovementKey(Minecraft.getInstance().screen, canMove)) {
            for (KeyMapping k : KeyMapping.ALL.values()) {
                if (k.key.getType() != InputConstants.Type.KEYSYM || k.key.getValue() == InputConstants.UNKNOWN.getValue()) continue;
                boolean raw = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)k.key.getValue());
                if (k instanceof ToggleKeyMapping && ((ToggleKeyMapping)k).needsToggle.getAsBoolean()) {
                    if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                        if (k == Minecraft.getInstance().options.keyShift) {
                            if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                                k.setDown(true);
                            }
                        } else {
                            k.setDown(true);
                        }
                    }
                    this.wasToggleKeyDown.put((ToggleKeyMapping)k, raw);
                    continue;
                }
                k.setDown(raw);
            }
            Minecraft.getInstance().options.keyDrop.setDown(false);
            if (!this.optionToggleCrouch()) {
                if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isPassenger()) {
                    Minecraft.getInstance().options.keyShift.setDown((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && Minecraft.getInstance().options.keyShift.isDown);
                } else {
                    boolean sneakKey = false;
                    switch ((InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get())) {
                        case Off: {
                            break;
                        }
                        case Maintain: {
                            sneakKey = this.wasSneaking;
                            break;
                        }
                        case Pressed: {
                            sneakKey = this.wasSneaking = Minecraft.getInstance().options.keyShift.isDown;
                        }
                    }
                    Minecraft.getInstance().options.keyShift.setDown(sneakKey);
                }
            }
            this.manualTickMovement(input, Minecraft.getInstance().player.isMovingSlowly(), Minecraft.getInstance().player.isSpectator());
        } else if (Minecraft.getInstance().screen != null) {
            KeyMapping.releaseAll();
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || Minecraft.getInstance().player != null && Minecraft.getInstance().player.isPassenger())) {
                boolean sneakKey = false;
                switch ((InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get())) {
                    case Off: {
                        break;
                    }
                    case Maintain: 
                    case Pressed: {
                        sneakKey = this.wasSneaking;
                    }
                }
                Minecraft.getInstance().options.keyShift.setDown(sneakKey);
                input.shiftKeyDown = sneakKey;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(Screen screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (screen.isPauseScreen() && Minecraft.getInstance().hasSingleplayerServer()) {
            if (Minecraft.getInstance().getSingleplayerServer() == null) {
                return false;
            }
            if (!Minecraft.getInstance().getSingleplayerServer().isPublished()) {
                return false;
            }
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void manualTickMovement(Input input, boolean slow, boolean noDampening) {
        input.up = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyUp);
        input.down = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyDown);
        input.left = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyLeft);
        input.right = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyRight);
        float f = input.up == input.down ? 0.0f : (input.forwardImpulse = (float)(input.up ? 1 : -1));
        input.leftImpulse = input.left == input.right ? 0.0f : (float)(input.left ? 1 : -1);
        input.jumping = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyJump) && (Boolean)InvMoveConfig.MOVEMENT.JUMP.get() != false;
        input.shiftKeyDown = InvMove.rawIsKeyDown(Minecraft.getInstance().options.keyShift);
        if (!noDampening && (input.shiftKeyDown || slow)) {
            input.leftImpulse = (float)((double)input.leftImpulse * 0.3);
            input.forwardImpulse = (float)((double)input.forwardImpulse * 0.3);
        }
    }

    public static boolean rawIsKeyDown(KeyMapping key) {
        return key.isDown;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(Screen screen) {
        void var2_8;
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.isPauseScreen()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!Minecraft.getInstance().hasSingleplayerServer()) break;
                    if (Minecraft.getInstance().getSingleplayerServer() == null) return false;
                    if (Minecraft.getInstance().getSingleplayerServer().isPublished()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            Screen screen = Minecraft.getInstance().screen;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                Object className = cl.getName();
                if (((String)className).startsWith("net.minecraft.")) {
                    className = ((String)className).substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + (String)className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + (String)className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + (String)className;
                }
                this.drawShadow(Minecraft.getInstance().font, new PoseStack(), (String)className, 4.0f, 4 + 10 * i, -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new KeyMapping("keybind.invmove.toggleMove", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "keycategory.invmove");
        addonModules = new ArrayList<Module>();
    }
}

