/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPostEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponseType;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BattleHandling {
    public static List<Pokemon> battlePokemonUsed = new ArrayList<Pokemon>();

    public static Unit getBattleInfo(BattleStartedPostEvent battleStartedPostEvent) {
        PokemonBattle battle = battleStartedPostEvent.getBattle();
        battlePokemonUsed.clear();
        block0: for (ServerPlayer player : battle.getPlayers()) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            player.setData(DataManage.BATTLE_ID, (Object)battle.getBattleId());
            if (Config.multipleMegas) {
                for (Pokemon pokemon : playerPartyStore) {
                    new FlagSpeciesFeature("mega", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                }
                continue;
            }
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon != player.getData(DataManage.MEGA_POKEMON)) continue;
                new FlagSpeciesFeature("mega", false).apply(pokemon);
                new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                player.setData(DataManage.MEGA_DATA, (Object)false);
                continue block0;
            }
        }
        return Unit.INSTANCE;
    }

    private static void broadCastEvoMsg(BattlePokemon battlePokemon, PokemonBattle battle, ServerPlayer player) {
        battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)battlePokemon).getEffectedPokemon(), battlePokemon.getEffectedPokemon().getAbility().getTemplate()));
        battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(battlePokemon.getEffectedPokemon()));
        AdvancementHelper.grantAdvancement(player, "mega_evolve");
        MutableComponent message = Component.literal((String)battlePokemon.getName().getString()).withStyle(style -> style.withColor(ChatFormatting.GOLD)).append(" ").append((Component)Component.literal((String)battlePokemon.getOriginalPokemon().getAbility().getName()).withStyle(style -> style.withColor(ChatFormatting.GOLD))).append(" activated!");
        battle.broadcastChatMessage((Component)message);
        String translatedDescription = Component.translatable((String)battlePokemon.getOriginalPokemon().getAbility().getDescription()).getString();
        battle.broadcastChatMessage((Component)Component.literal((String)translatedDescription).withStyle(style -> style.withColor(ChatFormatting.WHITE)));
    }

    public static void handleMegaEvolution(IPayloadContext userContext) {
        ServerPlayer player = (ServerPlayer)userContext.player();
        if (player.getData(DataManage.BATTLE_ID) == Util.NIL_UUID) {
            return;
        }
        PokemonBattle battle = BattleRegistry.INSTANCE.getBattle((UUID)player.getData(DataManage.BATTLE_ID));
        List<1> skipTurn = Collections.singletonList(new ShowdownActionResponse(ShowdownActionResponseType.FORCE_PASS){

            @NotNull
            public String toShowdownString(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset showdownMoveset) {
                return "pass";
            }

            public boolean isValid(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset showdownMoveset, boolean forceSwitch) {
                return true;
            }
        });
        battle.getPlayers().forEach(serverPlayer -> {
            for (BattlePokemon battlePokemon : battle.getActor(serverPlayer.getUUID()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null) continue;
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                if (battlePokemonUsed.contains(pokemon)) {
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"Pokemon already mega'ed").withColor(0xFF0000), true);
                    continue;
                }
                Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
                if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && (!((Boolean)serverPlayer.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
                    boolean found = false;
                    for (int i = 0; i < 4; ++i) {
                        if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                        serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                        serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                        new FlagSpeciesFeature("mega", true).apply(pokemon);
                        found = true;
                        if (Config.megaTurns) {
                            battle.getActor(serverPlayer).setActionResponses(skipTurn);
                        }
                        battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                        BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                        break;
                    }
                    if (!found) {
                        serverPlayer.displayClientMessage((Component)Component.literal((String)"Rayquaza doesn't have dragonascent").withColor(0xFF0000), true);
                    }
                    return;
                }
                if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
                    player.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
                    return;
                }
                if (species == null) {
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
                    return;
                }
                if (pokemon.getEntity().isBattling() && species.getName().equals(pokemon.getSpecies().getName()) && (!((Boolean)serverPlayer.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
                    if (species.getName().equals(Utils.getSpecies("charizard").getName())) {
                        if (pokemon.heldItem().is(ModItems.CHARIZARDITE_X)) {
                            serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                            serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                            new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                            new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                            if (Config.megaTurns) {
                                battle.getActor(serverPlayer).setActionResponses(skipTurn);
                            }
                            BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                            battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                            break;
                        }
                        if (!pokemon.heldItem().is(ModItems.CHARIZARDITE_Y)) continue;
                        serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                        serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                        new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                        new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                        if (Config.megaTurns) {
                            battle.getActor(serverPlayer).setActionResponses(skipTurn);
                        }
                        battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                        BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                        break;
                    }
                    if (species.getName().equals(Utils.getSpecies("mewtwo").getName())) {
                        if (pokemon.heldItem().is(ModItems.MEWTWONITE_X)) {
                            serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                            serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                            new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                            new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                            if (Config.megaTurns) {
                                battle.getActor(serverPlayer).setActionResponses(skipTurn);
                            }
                            battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                            BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                            break;
                        }
                        if (!pokemon.heldItem().is(ModItems.MEWTWONITE_Y)) continue;
                        serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                        serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                        new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                        new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                        if (Config.megaTurns) {
                            battle.getActor(serverPlayer).setActionResponses(skipTurn);
                        }
                        battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                        BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                        break;
                    }
                    serverPlayer.setData(DataManage.MEGA_DATA, (Object)true);
                    serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    new FlagSpeciesFeature("mega", true).apply(pokemon);
                    if (Config.megaTurns) {
                        battle.getActor(serverPlayer).setActionResponses(skipTurn);
                    }
                    battlePokemonUsed.add(battlePokemon.getOriginalPokemon());
                    BattleHandling.broadCastEvoMsg(battlePokemon, battle, player);
                    break;
                }
                if (species.getName().equals(pokemon.getSpecies().getName()) && ((Boolean)serverPlayer.getData(DataManage.MEGA_DATA)).booleanValue()) {
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
                    continue;
                }
                serverPlayer.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
            }
        });
    }

    public static Unit getBattleEndInfo(BattleVictoryEvent battleVictoryEvent) {
        battleVictoryEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            for (BattlePokemon battlePokemon : battleVictoryEvent.getBattle().getActor(serverPlayer.getUUID()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null) continue;
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                serverPlayer.setData(DataManage.MEGA_DATA, (Object)false);
                serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)new Pokemon());
                new FlagSpeciesFeature("mega", false).apply(pokemon);
                new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                new FlagSpeciesFeature("mega-y", false).apply(pokemon);
            }
            serverPlayer.setData(DataManage.BATTLE_ID, (Object)Util.NIL_UUID);
        });
        battlePokemonUsed.clear();
        return Unit.INSTANCE;
    }

    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        ServerPlayer serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null) {
            return Unit.INSTANCE;
        }
        serverPlayer.setData(DataManage.MEGA_DATA, (Object)false);
        serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)new Pokemon());
        new FlagSpeciesFeature("mega", false).apply(pokemon);
        new FlagSpeciesFeature("mega-x", false).apply(pokemon);
        new FlagSpeciesFeature("mega-y", false).apply(pokemon);
        return Unit.INSTANCE;
    }

    public static Unit deVolveFlee(BattleFledEvent battleFledEvent) {
        battleFledEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            for (BattlePokemon battlePokemon : battleFledEvent.getBattle().getActor(serverPlayer.getUUID()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null || battlePokemon.getOriginalPokemon().getEntity().level().isClientSide) continue;
                serverPlayer.setData(DataManage.MEGA_DATA, (Object)false);
                serverPlayer.setData(DataManage.MEGA_POKEMON, (Object)new Pokemon());
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                new FlagSpeciesFeature("mega", false).apply(pokemon);
                new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                new FlagSpeciesFeature("mega-y", false).apply(pokemon);
            }
            serverPlayer.setData(DataManage.BATTLE_ID, (Object)Util.NIL_UUID);
        });
        battlePokemonUsed.clear();
        return Unit.INSTANCE;
    }
}

