/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.network;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.net.PacketHandler;
import com.cobblemon.mod.common.net.PacketRegisterInfo;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.network.handlers.BuyHandler;
import fr.harmex.cobbledollars.common.network.handlers.SellHandler;
import fr.harmex.cobbledollars.common.network.handlers.SyncShopConfigHandler;
import fr.harmex.cobbledollars.common.network.handlers.SyncShopHandler;
import fr.harmex.cobbledollars.common.network.packets.c2s.BuyPacket;
import fr.harmex.cobbledollars.common.network.packets.c2s.SellPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopConfigPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u0007*\u00020\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\n\u001a\u00020\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\f\u001a\u00020\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\f\u0010\u000bJ'\u0010\u000f\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J!\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0017\u0010\tR!\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0014R!\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0019\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lfr/harmex/cobbledollars/common/network/CobbleDollarsNetwork;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "", "sendPacket", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "sendToServer", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "sendToAllPlayers", "", "players", "sendPacketToPlayers", "(Ljava/lang/Iterable;Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "", "Lcom/cobblemon/mod/common/net/PacketRegisterInfo;", "genS2CPacketInfoList", "()Ljava/util/List;", "genC2SPacketInfoList", "player", "sendPacketToPlayer", "s2cPayloads", "Ljava/util/List;", "getS2cPayloads", "c2sPayloads", "getC2sPayloads", "cobbledollars-common"})
@SourceDebugExtension(value={"SMAP\nCobbleDollarsNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleDollarsNetwork.kt\nfr/harmex/cobbledollars/common/network/CobbleDollarsNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 CobbleDollarsNetwork.kt\nfr/harmex/cobbledollars/common/network/CobbleDollarsNetwork\n*L\n28#1:55,2\n*E\n"})
public final class CobbleDollarsNetwork {
    @NotNull
    public static final CobbleDollarsNetwork INSTANCE = new CobbleDollarsNetwork();
    @NotNull
    private static final List<PacketRegisterInfo<?>> s2cPayloads = INSTANCE.genS2CPacketInfoList();
    @NotNull
    private static final List<PacketRegisterInfo<?>> c2sPayloads = INSTANCE.genC2SPacketInfoList();

    private CobbleDollarsNetwork() {
    }

    public final void sendPacket(@NotNull ServerPlayer $this$sendPacket, @NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPacket, (String)"<this>");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.sendPacketToPlayer($this$sendPacket, packet);
    }

    public final void sendToServer(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CobbleDollars.INSTANCE.getImplementation().getNetworkManager().sendToServer(packet);
    }

    public final void sendToAllPlayers(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        List list = minecraftServer.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        this.sendPacketToPlayers(list, packet);
    }

    public final void sendPacketToPlayers(@NotNull Iterable<? extends ServerPlayer> players, @NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Iterable<? extends ServerPlayer> $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        Iterator<? extends ServerPlayer> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ServerPlayer element$iv;
            ServerPlayer it = element$iv = iterator.next();
            boolean bl = false;
            INSTANCE.sendPacketToPlayer(it, packet);
        }
    }

    @NotNull
    public final List<PacketRegisterInfo<?>> getS2cPayloads() {
        return s2cPayloads;
    }

    @NotNull
    public final List<PacketRegisterInfo<?>> getC2sPayloads() {
        return c2sPayloads;
    }

    private final List<PacketRegisterInfo<?>> genS2CPacketInfoList() {
        List list = new ArrayList();
        ResourceLocation resourceLocation = SyncShopConfigPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation, (Function1)new Function1<RegistryFriendlyByteBuf, SyncShopConfigPacket>((Object)SyncShopConfigPacket.Companion){

            public final SyncShopConfigPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SyncShopConfigPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)SyncShopConfigHandler.INSTANCE, null, 8, null));
        ResourceLocation resourceLocation2 = SyncShopPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation2, (Function1)new Function1<RegistryFriendlyByteBuf, SyncShopPacket>((Object)SyncShopPacket.Companion){

            public final SyncShopPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SyncShopPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)SyncShopHandler.INSTANCE, null, 8, null));
        return list;
    }

    private final List<PacketRegisterInfo<?>> genC2SPacketInfoList() {
        List list = new ArrayList();
        ResourceLocation resourceLocation = BuyPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation, (Function1)new Function1<RegistryFriendlyByteBuf, BuyPacket>((Object)BuyPacket.Companion){

            public final BuyPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BuyPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)BuyHandler.INSTANCE, null, 8, null));
        ResourceLocation resourceLocation2 = SellPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation2, (Function1)new Function1<RegistryFriendlyByteBuf, SellPacket>((Object)SellPacket.Companion){

            public final SellPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SellPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)SellHandler.INSTANCE, null, 8, null));
        return list;
    }

    public final void sendPacketToPlayer(@NotNull ServerPlayer player, @NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CobbleDollars.INSTANCE.getImplementation().getNetworkManager().sendPacketToPlayer(player, packet);
    }
}

