/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.world.item.trading.ICobbleMerchant;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ZombieVillager.class})
public class ZombieVillagerMixin
implements ICobbleMerchant {
    @Unique
    private Shop shop = new Shop();

    @Inject(method={"finishConversion(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;setVillagerData(Lnet/minecraft/world/entity/npc/VillagerData;)V", shift=At.Shift.AFTER)})
    private void transferCobbleMerchantShop(ServerLevel serverLevel, CallbackInfo ci, @Local Villager villager) {
        ((ICobbleMerchant)villager).setShop(this.shop);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void addShopToNbt(CompoundTag compound, CallbackInfo ci) {
        CompoundTagExtensionKt.putShop(compound, this.shop, this.cobbleDollars$self().registryAccess());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void readShopFromNbt(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CobbleMerchantShop")) {
            this.shop = CompoundTagExtensionKt.getShop(compound, this.cobbleDollars$self().registryAccess());
        }
    }

    @Override
    @Unique
    @NotNull
    public Shop getShop() {
        return this.shop;
    }

    @Override
    @Unique
    public void setShop(@NotNull Shop shop) {
        this.shop = shop;
    }

    @Unique
    private ZombieVillager cobbleDollars$self() {
        return (ZombieVillager)this;
    }
}

