/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.mixin;

import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.entity.villager.CobbleDollarsProfessions;
import fr.harmex.cobbledollars.common.world.item.trading.ICobbleMerchant;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
implements ICobbleMerchant {
    @Unique
    private Shop shop = new Shop();

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;level()Lnet/minecraft/world/level/Level;", ordinal=1, shift=At.Shift.AFTER)}, cancellable=true)
    private void cobbleMerchantInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.cobbleDollars$isCobbleMerchant() && !player.level().isClientSide) {
            if (player.isShiftKeyDown()) {
                PlayerExtensionKt.openBank(player);
            } else {
                PlayerExtensionKt.openShop(player, this);
            }
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void addShopToNbt(CompoundTag compound, CallbackInfo ci) {
        CompoundTagExtensionKt.putShop(compound, this.shop, this.cobbleDollars$self().registryAccess());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void readShopFromNbt(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CobbleMerchantShop")) {
            this.shop = CompoundTagExtensionKt.getShop(compound, this.cobbleDollars$self().registryAccess());
        }
    }

    @Override
    @Unique
    @NotNull
    public Shop getShop() {
        return this.shop;
    }

    @Override
    @Unique
    public void setShop(@NotNull Shop shop) {
        this.shop = shop;
    }

    @Unique
    private boolean cobbleDollars$isCobbleMerchant() {
        return this.cobbleDollars$self().getVillagerData().getProfession() == CobbleDollarsProfessions.COBBLE_MERCHANT;
    }

    @Unique
    private Villager cobbleDollars$self() {
        return (Villager)this;
    }
}

