/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.config;

import com.cobblemon.mod.common.CobblemonItems;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.utils.adapters.ShopAdapter;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Category;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lfr/harmex/cobbledollars/common/config/ShopConfig;", "", "<init>", "()V", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "defaultShop", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "getDefaultShop", "()Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "setDefaultShop", "(Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;)V", "Companion", "cobbledollars-common"})
public final class ShopConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Shop defaultShop;
    @NotNull
    public static final String PATH = "config/cobbledollars/default_shop.json";
    @NotNull
    private static final Gson GSON;

    public ShopConfig() {
        Category[] categoryArray = new Category[2];
        Object[] objectArray = new Offer[]{new Offer(new ItemStack((ItemLike)CobblemonItems.POKE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.CITRINE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.VERDANT_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.AZURE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ROSEATE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.SLATE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.PREMIER_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.GREAT_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.ULTRA_BALL), 8000), new Offer(new ItemStack((ItemLike)CobblemonItems.SAFARI_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.FAST_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.LEVEL_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.LURE_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.HEAVY_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.LOVE_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.FRIEND_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.MOON_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.SPORT_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.PARK_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.NET_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.DIVE_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.NEST_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.REPEAT_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.TIMER_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.LUXURY_BALL), 30000), new Offer(new ItemStack((ItemLike)CobblemonItems.DUSK_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.HEAL_BALL), 3000), new Offer(new ItemStack((ItemLike)CobblemonItems.QUICK_BALL), 10000), new Offer(new ItemStack((ItemLike)CobblemonItems.DREAM_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.BEAST_BALL), 50000), new Offer(new ItemStack((ItemLike)CobblemonItems.MASTER_BALL), 500000), new Offer(new ItemStack((ItemLike)CobblemonItems.CHERISH_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_POKE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_CITRINE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_VERDANT_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_AZURE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_ROSEATE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_SLATE_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_IVORY_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_GREAT_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_ULTRA_BALL), 8000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_FEATHER_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_WING_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_JET_BALL), 8000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_HEAVY_BALL), 2000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_LEADEN_BALL), 6000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_GIGATON_BALL), 8000), new Offer(new ItemStack((ItemLike)CobblemonItems.ANCIENT_ORIGIN_BALL), 500000)};
        categoryArray[0] = new Category("Pok\u00e9 Balls", CollectionsKt.arrayListOf((Object[])objectArray));
        objectArray = new Offer[]{new Offer(new ItemStack((ItemLike)CobblemonItems.EXPERIENCE_CANDY_XS), 500), new Offer(new ItemStack((ItemLike)CobblemonItems.EXPERIENCE_CANDY_S), 4000), new Offer(new ItemStack((ItemLike)CobblemonItems.EXPERIENCE_CANDY_M), 15000), new Offer(new ItemStack((ItemLike)CobblemonItems.EXPERIENCE_CANDY_L), 50000), new Offer(new ItemStack((ItemLike)CobblemonItems.EXPERIENCE_CANDY_XL), 150000), new Offer(new ItemStack((ItemLike)CobblemonItems.RARE_CANDY), 100000), new Offer(new ItemStack((ItemLike)CobblemonItems.EXP_SHARE), 250000)};
        categoryArray[1] = new Category("Exp", CollectionsKt.arrayListOf((Object[])objectArray));
        this.defaultShop = new Shop(categoryArray);
    }

    @NotNull
    public final Shop getDefaultShop() {
        return this.defaultShop;
    }

    public final void setDefaultShop(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"<set-?>");
        this.defaultShop = shop;
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)Shop.class), (Object)new ShopAdapter()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lfr/harmex/cobbledollars/common/config/ShopConfig$Companion;", "", "<init>", "()V", "", "load", "save", "", "PATH", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "cobbledollars-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public final void load() {
            File configFile = new File(ShopConfig.PATH);
            configFile.getParentFile().mkdirs();
            boolean defaultConfig = false;
            if (configFile.exists()) {
                try {
                    FileReader reader = new FileReader(configFile);
                    CobbleDollars.INSTANCE.setShopConfig((ShopConfig)this.getGSON().fromJson((Reader)reader, ShopConfig.class));
                    reader.close();
                }
                catch (Exception exception) {
                    CobbleDollars.INSTANCE.setShopConfig(new ShopConfig());
                    defaultConfig = true;
                    CobbleDollars.INSTANCE.getLOGGER().error("Failed to load the shop config! Using default config until the following has been addressed:");
                    exception.printStackTrace();
                }
            } else {
                CobbleDollars.INSTANCE.setShopConfig(new ShopConfig());
            }
            if (!defaultConfig) {
                this.save();
            }
        }

        public final void save() {
            try {
                File configFile = new File(ShopConfig.PATH);
                FileWriter writer = new FileWriter(configFile);
                this.getGSON().toJson((Object)CobbleDollars.INSTANCE.getShopConfig(), (Appendable)writer);
                writer.close();
            }
            catch (Exception exception) {
                CobbleDollars.INSTANCE.getLOGGER().error("Failed to save the shop config! Please consult the following stack trace:");
                exception.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

