/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.utils.adapters.BankAdapter;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Bank;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lfr/harmex/cobbledollars/common/config/BankConfig;", "", "<init>", "()V", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Bank;", "bank", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Bank;", "getBank", "()Lfr/harmex/cobbledollars/common/world/item/trading/shop/Bank;", "setBank", "(Lfr/harmex/cobbledollars/common/world/item/trading/shop/Bank;)V", "Companion", "cobbledollars-common"})
public final class BankConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Bank bank;
    @NotNull
    public static final String PATH = "config/cobbledollars/bank.json";
    @NotNull
    private static final Gson GSON;

    public BankConfig() {
        Offer[] offerArray = new Offer[]{new Offer(new ItemStack((ItemLike)Items.EMERALD), new BigInteger("750"))};
        this.bank = new Bank(offerArray);
    }

    @NotNull
    public final Bank getBank() {
        return this.bank;
    }

    public final void setBank(@NotNull Bank bank) {
        Intrinsics.checkNotNullParameter((Object)bank, (String)"<set-?>");
        this.bank = bank;
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)Bank.class), (Object)new BankAdapter()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lfr/harmex/cobbledollars/common/config/BankConfig$Companion;", "", "<init>", "()V", "", "load", "save", "", "PATH", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "cobbledollars-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public final void load() {
            File configFile = new File(BankConfig.PATH);
            configFile.getParentFile().mkdirs();
            boolean defaultConfig = false;
            if (configFile.exists()) {
                try {
                    FileReader reader = new FileReader(configFile);
                    CobbleDollars.INSTANCE.setBankConfig((BankConfig)this.getGSON().fromJson((Reader)reader, BankConfig.class));
                    reader.close();
                }
                catch (Exception exception) {
                    CobbleDollars.INSTANCE.setBankConfig(new BankConfig());
                    defaultConfig = true;
                    CobbleDollars.INSTANCE.getLOGGER().error("Failed to load the shop config! Using default config until the following has been addressed:");
                    exception.printStackTrace();
                }
            } else {
                CobbleDollars.INSTANCE.setBankConfig(new BankConfig());
            }
            if (!defaultConfig) {
                this.save();
            }
        }

        public final void save() {
            try {
                File configFile = new File(BankConfig.PATH);
                FileWriter writer = new FileWriter(configFile);
                this.getGSON().toJson((Object)CobbleDollars.INSTANCE.getBankConfig(), (Appendable)writer);
                writer.close();
            }
            catch (Exception exception) {
                CobbleDollars.INSTANCE.getLOGGER().error("Failed to save the shop config! Please consult the following stack trace:");
                exception.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

