/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.command;

import com.cobblemon.mod.common.api.text.TextKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.command.arguments.BigIntegerArgumentType;
import fr.harmex.cobbledollars.common.config.BankConfig;
import fr.harmex.cobbledollars.common.config.CommonConfig;
import fr.harmex.cobbledollars.common.config.ShopConfig;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopConfigPacket;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J-\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lfr/harmex/cobbledollars/common/command/CobbleDollarsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "sourceStack", "Lnet/minecraft/server/level/ServerPlayer;", "target", "Ljava/math/BigInteger;", "amount", "", "pay", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/server/level/ServerPlayer;Ljava/math/BigInteger;)I", "Lnet/minecraft/world/entity/player/Player;", "query", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/world/entity/player/Player;)I", "", "targets", "give", "(Lnet/minecraft/commands/CommandSourceStack;Ljava/util/Collection;Ljava/math/BigInteger;)I", "remove", "set", "reload", "(Lnet/minecraft/commands/CommandSourceStack;)I", "cobbledollars-common"})
public final class CobbleDollarsCommand {
    @NotNull
    public static final CobbleDollarsCommand INSTANCE = new CobbleDollarsCommand();

    private CobbleDollarsCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralCommandNode mainNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cobbledollars").then(Commands.literal((String)"pay").then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$0))))).then(Commands.literal((String)"query").then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(CobbleDollarsCommand::register$lambda$1)))).then(((LiteralArgumentBuilder)Commands.literal((String)"give").requires(CobbleDollarsCommand::register$lambda$2)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$3))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(CobbleDollarsCommand::register$lambda$4)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$5))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(CobbleDollarsCommand::register$lambda$6)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(0)).executes(CobbleDollarsCommand::register$lambda$7))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(CobbleDollarsCommand::register$lambda$8)).executes(CobbleDollarsCommand::register$lambda$9)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"cd").redirect((CommandNode)mainNode));
    }

    private final int pay(CommandSourceStack sourceStack, ServerPlayer target, BigInteger amount) {
        ServerPlayer serverPlayer = sourceStack.getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        if (amount.compareTo(PlayerExtensionKt.getCobbleDollars((Player)serverPlayer)) > 0) {
            sourceStack.sendFailure((Component)MiscUtilsKt.cobbleDollarsCommand("pay.fail", new Object[0]));
            return 0;
        }
        ServerPlayer serverPlayer2 = sourceStack.getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer2, (String)"getPlayerOrException(...)");
        Player player = (Player)serverPlayer2;
        BigInteger bigInteger = amount.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
        PlayerExtensionKt.addCobbleDollars(player, bigInteger);
        PlayerExtensionKt.addCobbleDollars((Player)target, amount);
        Object[] objectArray = new Object[2];
        ServerPlayer serverPlayer3 = sourceStack.getPlayer();
        Intrinsics.checkNotNull((Object)serverPlayer3);
        Intrinsics.checkNotNull((Object)serverPlayer3.getDisplayName());
        objectArray[1] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(amount, false, 1, null));
        target.sendSystemMessage((Component)MiscUtilsKt.cobbleDollarsCommand("pay.receive", objectArray));
        sourceStack.sendSuccess(() -> CobbleDollarsCommand.pay$lambda$10(amount, target), true);
        return amount.intValue();
    }

    private final int query(CommandSourceStack sourceStack, Player target) {
        BigInteger cobbleDollars = PlayerExtensionKt.getCobbleDollars(target);
        sourceStack.sendSuccess(() -> CobbleDollarsCommand.query$lambda$11(target, cobbleDollars), false);
        return cobbleDollars.intValue();
    }

    private final int give(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            PlayerExtensionKt.addCobbleDollars((Player)serverPlayer, amount);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.give$lambda$12(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.give$lambda$13(amount, targets), true);
        }
        return targets.size();
    }

    private final int remove(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            Player player = (Player)serverPlayer;
            BigInteger bigInteger = amount.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
            PlayerExtensionKt.addCobbleDollars(player, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.remove$lambda$14(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.remove$lambda$15(amount, targets), true);
        }
        return targets.size();
    }

    private final int set(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            PlayerExtensionKt.setCobbleDollars((Player)serverPlayer, amount);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.set$lambda$16(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.set$lambda$17(amount, targets), true);
        }
        return targets.size();
    }

    private final int reload(CommandSourceStack sourceStack) {
        CommonConfig.Companion.load();
        ShopConfig.Companion.load();
        BankConfig.Companion.load();
        CobbleDollarsNetwork.INSTANCE.sendToAllPlayers(new SyncShopConfigPacket(CobbleDollars.INSTANCE.getShopConfig().getDefaultShop(), CobbleDollars.INSTANCE.getBankConfig().getBank()));
        sourceStack.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)"Reloaded CobbleDollars config!"), false);
        return 1;
    }

    private static final int register$lambda$0(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ServerPlayer serverPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        Intrinsics.checkNotNull((Object)context);
        BigInteger bigInteger = BigIntegerArgumentType.Companion.getBigInteger(context, "amount");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getBigInteger(...)");
        return INSTANCE.pay(commandSourceStack, serverPlayer, bigInteger);
    }

    private static final int register$lambda$1(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ServerPlayer serverPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        return INSTANCE.query(commandSourceStack, (Player)serverPlayer);
    }

    private static final boolean register$lambda$2(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$3(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        BigInteger bigInteger = BigIntegerArgumentType.Companion.getBigInteger(context, "amount");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getBigInteger(...)");
        return INSTANCE.give(commandSourceStack, collection, bigInteger);
    }

    private static final boolean register$lambda$4(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$5(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        BigInteger bigInteger = BigIntegerArgumentType.Companion.getBigInteger(context, "amount");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getBigInteger(...)");
        return INSTANCE.remove(commandSourceStack, collection, bigInteger);
    }

    private static final boolean register$lambda$6(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$7(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        BigInteger bigInteger = BigIntegerArgumentType.Companion.getBigInteger(context, "amount");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getBigInteger(...)");
        return INSTANCE.set(commandSourceStack, collection, bigInteger);
    }

    private static final boolean register$lambda$8(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$9(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((CommandSourceStack)object);
    }

    private static final Component pay$lambda$10(BigInteger $amount, ServerPlayer $target) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)$target.getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("pay.success", objectArray);
    }

    private static final Component query$lambda$11(Player $target, BigInteger $cobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$cobbleDollars, (String)"$cobbleDollars");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$target.getDisplayName());
        objectArray[1] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($cobbleDollars, false, 1, null));
        return (Component)MiscUtilsKt.cobbleDollarsCommand("query.success", objectArray);
    }

    private static final Component give$lambda$12(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("give.success.single", objectArray);
    }

    private static final Component give$lambda$13(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("give.success.multiple", objectArray);
    }

    private static final Component remove$lambda$14(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("remove.success.single", objectArray);
    }

    private static final Component remove$lambda$15(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("remove.success.multiple", objectArray);
    }

    private static final Component set$lambda$16(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("set.success.single", objectArray);
    }

    private static final Component set$lambda$17(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("set.success.multiple", objectArray);
    }
}

