/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.color;

import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.color.ColorRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public record ColorKeyImpl(float[] rgbComponents, float[] defaultRgbComponents) implements ColorKey
{
    private static final Codec<Pair<ResourceLocation, String>> CATEGORY_AND_ID_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("category").forGetter(Pair::getFirst), (App)Codec.STRING.fieldOf("id").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private static final Codec<ColorKey> FULL_CODEC = CATEGORY_AND_ID_CODEC.flatXmap(categoryAndId -> {
        ResourceLocation category = (ResourceLocation)categoryAndId.getFirst();
        String id = (String)categoryAndId.getSecond();
        @Nullable ColorKey key = ColorRegistryImpl.INSTANCE.category(category).key(id);
        if (key == null) {
            return DataResult.error(() -> "Unknown color key " + id + " in category " + String.valueOf(category));
        }
        return DataResult.success((Object)key);
    }, key -> DataResult.error(() -> "Cannot encode color key " + String.valueOf(key) + " as a string"));
    private static final Codec<ColorKey> INT_CODEC = Codec.INT.xmap(ColorKey::ofRgb, ColorKey::rgb);
    public static final Codec<ColorKey> CODEC = Codec.withAlternative(FULL_CODEC, INT_CODEC);

    @Override
    public int rgb() {
        return ShulkerBoxTooltipUtil.componentsToRgb(this.rgbComponents());
    }

    @Override
    public int defaultRgb() {
        return ShulkerBoxTooltipUtil.componentsToRgb(this.defaultRgbComponents());
    }

    @Override
    public void setRgb(int rgb) {
        this.setRgb(ShulkerBoxTooltipUtil.rgbToComponents(rgb));
    }

    @Override
    public void setRgb(float[] rgb) {
        this.rgbComponents[0] = rgb[0];
        this.rgbComponents[1] = rgb[1];
        this.rgbComponents[2] = rgb[2];
    }

    @Override
    public String toString() {
        return String.format("ColorKey(rgb=#%x, defaultRgb=#%x)", this.rgb(), this.defaultRgb());
    }
}

