/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.util;

import com.cobblemon.mod.common.util.DistributionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000e\u0010\u0010J#\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/util/PlayerUtil;", "", "<init>", "()V", "Lnet/minecraft/core/BlockPos;", "pos", "", "range", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "dimensionKey", "playerLimit", "", "Lnet/minecraft/world/entity/player/Player;", "getValidPlayers", "(Lnet/minecraft/core/BlockPos;ILnet/minecraft/resources/ResourceKey;I)Ljava/util/List;", "(Lnet/minecraft/core/BlockPos;ILnet/minecraft/resources/ResourceKey;)Ljava/util/List;", "level", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Ljava/util/List;", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nPlayerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerUtil.kt\nus/timinc/mc/cobblemon/spawnnotification/util/PlayerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1053#2:52\n774#2:53\n865#2,2:54\n*S KotlinDebug\n*F\n+ 1 PlayerUtil.kt\nus/timinc/mc/cobblemon/spawnnotification/util/PlayerUtil\n*L\n23#1:52\n41#1:53\n41#1:54,2\n*E\n"})
public final class PlayerUtil {
    @NotNull
    public static final PlayerUtil INSTANCE = new PlayerUtil();

    private PlayerUtil() {
    }

    @NotNull
    public final List<Player> getValidPlayers(@NotNull BlockPos pos, int range, @NotNull ResourceKey<Level> dimensionKey, int playerLimit) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(dimensionKey, (String)"dimensionKey");
        Iterable $this$sortedBy$iv = this.getValidPlayers(pos, range, dimensionKey);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(pos){
            final /* synthetic */ BlockPos $pos$inlined;
            {
                this.$pos$inlined = blockPos;
            }

            public final int compare(T a, T b) {
                Player it = (Player)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(Math.sqrt(this.$pos$inlined.distSqr((Vec3i)it.blockPosition())));
                it = (Player)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(Math.sqrt(this.$pos$inlined.distSqr((Vec3i)it.blockPosition()))));
            }
        }), (int)playerLimit);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> getValidPlayers(@NotNull BlockPos pos, int range, @NotNull ResourceKey<Level> dimensionKey) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(dimensionKey, (String)"dimensionKey");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        if (minecraftServer == null) {
            return CollectionsKt.emptyList();
        }
        MinecraftServer serverInstance = minecraftServer;
        List list = serverInstance.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            if (!(Math.sqrt(pos.distSqr((Vec3i)it.blockPosition())) <= (double)range && Intrinsics.areEqual(dimensionKey, (Object)it.level().dimension()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Player> getValidPlayers(@NotNull Level level, @NotNull BlockPos pos) {
        List<Player> list;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (SpawnNotification.INSTANCE.getConfig().getPlayerLimitEnabled()) {
            int n = SpawnNotification.INSTANCE.getConfig().getBroadcastRange();
            ResourceKey resourceKey = level.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            list = this.getValidPlayers(pos, n, (ResourceKey<Level>)resourceKey, SpawnNotification.INSTANCE.getConfig().getPlayerLimit());
        } else {
            int n = SpawnNotification.INSTANCE.getConfig().getBroadcastRange();
            ResourceKey resourceKey = level.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            list = this.getValidPlayers(pos, n, (ResourceKey<Level>)resourceKey);
        }
        return list;
    }
}

