/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.SoundBroadcaster;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/PlayShinyPlayerSound;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonSentPostEvent;", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonSentPostEvent;)V", "cobblemon-spawn-notification"})
public final class PlayShinyPlayerSound {
    @NotNull
    public static final PlayShinyPlayerSound INSTANCE = new PlayShinyPlayerSound();

    private PlayShinyPlayerSound() {
    }

    public final void handle(@NotNull PokemonSentPostEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getPlayShinySoundPlayer() || !evt.getPokemon().getShiny()) {
            return;
        }
        Level level = evt.getPokemonEntity().level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        BlockPos blockPos = evt.getPokemonEntity().blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        new SoundBroadcaster(level, blockPos, SpawnNotification.getSHINY_SOUND_EVENT()).playShinySound();
    }
}

