/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonFaintedEvent;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.DespawnBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.DespawnReason;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ?\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastDespawn;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;)V", "Lnet/neoforged/neoforge/event/entity/EntityLeaveLevelEvent;", "(Lnet/neoforged/neoforge/event/entity/EntityLeaveLevelEvent;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/core/BlockPos;", "coords", "Lnet/minecraft/resources/ResourceLocation;", "biome", "dimension", "Lnet/minecraft/world/level/Level;", "level", "Lus/timinc/mc/cobblemon/spawnnotification/util/DespawnReason;", "reason", "broadcast", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/level/Level;Lus/timinc/mc/cobblemon/spawnnotification/util/DespawnReason;)V", "cobblemon-spawn-notification"})
public final class BroadcastDespawn {
    @NotNull
    public static final BroadcastDespawn INSTANCE = new BroadcastDespawn();

    private BroadcastDespawn() {
    }

    public final void handle(@NotNull PokemonCapturedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastDespawns()) {
            return;
        }
        EmptyPokeBallEntity entity = evt.getPokeBallEntity();
        BlockPos coords = entity.blockPosition();
        Level level = entity.level();
        Pokemon pokemon = evt.getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = WorldExtensionsKt.getBiomeRegistry((Level)level).getKey(level.getBiome(coords).value());
        Intrinsics.checkNotNull((Object)resourceLocation);
        ResourceLocation resourceLocation2 = level.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, level, DespawnReason.CAPTURED);
    }

    public final void handle(@NotNull PokemonFaintedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastDespawns()) {
            return;
        }
        if (!evt.getPokemon().isWild()) {
            return;
        }
        PokemonEntity pokemonEntity = evt.getPokemon().getEntity();
        if (pokemonEntity == null) {
            return;
        }
        PokemonEntity entity = pokemonEntity;
        BlockPos coords = entity.blockPosition();
        Level level = entity.level();
        Pokemon pokemon = evt.getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = WorldExtensionsKt.getBiomeRegistry((Level)level).getKey(level.getBiome(coords).value());
        Intrinsics.checkNotNull((Object)resourceLocation);
        ResourceLocation resourceLocation2 = level.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, level, DespawnReason.FAINTED);
    }

    public final void handle(@NotNull EntityLeaveLevelEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastVolatileDespawns()) {
            return;
        }
        Entity entity = evt.getEntity();
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        BlockPos coords = ((PokemonEntity)entity).blockPosition();
        Level level = evt.getLevel();
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = WorldExtensionsKt.getBiomeRegistry((Level)level).getKey(level.getBiome(coords).value());
        Intrinsics.checkNotNull((Object)resourceLocation);
        ResourceLocation resourceLocation2 = level.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, level, DespawnReason.DESPAWNED);
    }

    private final void broadcast(Pokemon pokemon, BlockPos coords, ResourceLocation biome, ResourceLocation dimension, Level level, DespawnReason reason) {
        block4: {
            Component component = new DespawnBroadcaster(pokemon, CobblemonSpawnPools.INSTANCE.getWORLD_SPAWN_POOL(), coords, biome, dimension, reason).getBroadcast();
            if (component == null) break block4;
            Component message = component;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
            } else if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers(level, coords), message);
            } else {
                Broadcast.INSTANCE.broadcastMessage(level, message);
            }
        }
    }
}

