/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay {
    @Nullable
    private final SmithingRecipeType type;

    @ApiStatus.Experimental
    public static DefaultSmithingDisplay ofTransforming(RecipeHolder<SmithingTransformRecipe> recipe) {
        return new DefaultSmithingDisplay((SmithingRecipe)recipe.value(), recipe.id(), List.of(EntryIngredients.ofIngredient(((SmithingTransformRecipe)recipe.value()).template), EntryIngredients.ofIngredient(((SmithingTransformRecipe)recipe.value()).base), EntryIngredients.ofIngredient(((SmithingTransformRecipe)recipe.value()).addition)));
    }

    public static List<DefaultSmithingDisplay> fromTrimming(RecipeHolder<SmithingTrimRecipe> recipe) {
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (ItemStack templateItem : ((SmithingTrimRecipe)recipe.value()).template.getItems()) {
            Holder.Reference trimPattern = TrimPatterns.getFromTemplate((HolderLookup.Provider)registryAccess, (ItemStack)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (ItemStack additionStack : ((SmithingTrimRecipe)recipe.value()).addition.getItems()) {
                Holder.Reference trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                EntryIngredient baseIngredient = EntryIngredients.ofIngredient(((SmithingTrimRecipe)recipe.value()).base);
                EntryIngredient templateOutput = baseIngredient.isEmpty() ? EntryIngredient.empty() : DefaultSmithingDisplay.getTrimmingOutput(registryAccess, EntryStacks.of(templateItem), (EntryStack)baseIngredient.get(0), EntryStacks.of(additionStack));
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.of(templateItem), baseIngredient, EntryIngredients.of(additionStack)), List.of(templateOutput), SmithingRecipeType.TRIM, Optional.ofNullable(recipe.id())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(SmithingRecipe recipe, @Nullable ResourceLocation id, List<EntryIngredient> inputs) {
        this(inputs, List.of(EntryIngredients.of(recipe.getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()))), Optional.ofNullable(id));
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        this(inputs, outputs, null, location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, @Nullable SmithingRecipeType type, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    @ApiStatus.Experimental
    @Nullable
    public SmithingRecipeType getType() {
        return this.type;
    }

    public static BasicDisplay.Serializer<DefaultSmithingDisplay> serializer() {
        return BasicDisplay.Serializer.of((input, output, id, tag) -> {
            SmithingRecipeType type = tag.contains("Type") ? SmithingRecipeType.valueOf(tag.getString("Type")) : null;
            return new DefaultSmithingDisplay(input, output, type, id);
        }, (display, tag) -> {
            if (display.type != null) {
                tag.putString("Type", display.type.name());
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(RegistryAccess registryAccess, EntryStack<?> template, EntryStack<?> base, EntryStack<?> addition) {
        if (template.getType() != VanillaEntryTypes.ITEM || base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        ItemStack templateItem = (ItemStack)template.castValue();
        ItemStack baseItem = (ItemStack)base.castValue();
        ItemStack additionItem = (ItemStack)addition.castValue();
        Holder.Reference trimPattern = TrimPatterns.getFromTemplate((HolderLookup.Provider)registryAccess, (ItemStack)templateItem).orElse(null);
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        Holder.Reference trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        ArmorTrim armorTrim = new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
        ArmorTrim trim = (ArmorTrim)baseItem.get(DataComponents.TRIM);
        if (trim != null && trim.hasPatternAndMaterial((Holder)trimPattern, (Holder)trimMaterial)) {
            return EntryIngredient.empty();
        }
        ItemStack newItem = baseItem.copyWithCount(1);
        newItem.set(DataComponents.TRIM, (Object)armorTrim);
        return EntryIngredients.of(newItem);
    }

    @ApiStatus.Experimental
    public static enum SmithingRecipeType {
        TRIM,
        TRANSFORM;

    }
}

