/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCraftingCategory
implements DisplayCategory<DefaultCraftingDisplay<?>> {
    @Override
    public CategoryIdentifier<? extends DefaultCraftingDisplay<?>> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.CRAFTING_TABLE);
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"category.rei.crafting");
    }

    @Override
    public List<Widget> setupDisplay(DefaultCraftingDisplay<?> display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createArrow(new Point(startPoint.x + 60, startPoint.y + 18)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 95, startPoint.y + 19)));
        List<InputIngredient<EntryStack<?>>> input = display.getInputIngredients(3, 3);
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot(new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput());
            }
        }
        for (InputIngredient<EntryStack<?>> ingredient : input) {
            ((Slot)slots.get(ingredient.getIndex())).entries(ingredient.get());
        }
        widgets.addAll(slots);
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 95, startPoint.y + 19)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
        if (display.isShapeless()) {
            widgets.add(Widgets.createShapelessIcon(bounds));
        }
        return widgets;
    }

    @Override
    @Nullable
    public DisplayMerger<DefaultCraftingDisplay<?>> getDisplayMerger() {
        return new DisplayMerger<DefaultCraftingDisplay<?>>(this){

            @Override
            public boolean canMerge(DefaultCraftingDisplay<?> first, DefaultCraftingDisplay<?> second) {
                if (!first.getCategoryIdentifier().equals(second.getCategoryIdentifier())) {
                    return false;
                }
                if (!this.equals(first.getOrganisedInputEntries(3, 3), second.getOrganisedInputEntries(3, 3))) {
                    return false;
                }
                if (!this.equals(first.getOutputEntries(), second.getOutputEntries())) {
                    return false;
                }
                if (first.isShapeless() != second.isShapeless()) {
                    return false;
                }
                if (first.getWidth() != second.getWidth()) {
                    return false;
                }
                return first.getHeight() == second.getHeight();
            }

            @Override
            public int hashOf(DefaultCraftingDisplay<?> display) {
                return display.getCategoryIdentifier().hashCode() * 31 * 31 * 31 + display.getOrganisedInputEntries(3, 3).hashCode() * 31 * 31 + display.getOutputEntries().hashCode();
            }

            private boolean equals(List<EntryIngredient> l1, List<EntryIngredient> l2) {
                if (l1.size() != l2.size()) {
                    return false;
                }
                Iterator<EntryIngredient> it1 = l1.iterator();
                Iterator<EntryIngredient> it2 = l2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (it1.next().equals(it2.next())) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

