/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalRegistryAccess
implements Supplier<RegistryAccess> {
    private static final InternalRegistryAccess INSTANCE = new InternalRegistryAccess();
    private WeakReference<RegistryAccess> registryAccess;
    private boolean warned;

    public static InternalRegistryAccess getInstance() {
        return INSTANCE;
    }

    @Override
    public RegistryAccess get() {
        RegistryAccess access;
        RegistryAccess registryAccess = access = this.registryAccess == null ? null : (RegistryAccess)this.registryAccess.get();
        if (access != null) {
            return access;
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            access = InternalRegistryAccess.getFromClient();
        } else if (GameInstance.getServer() != null) {
            access = GameInstance.getServer().registryAccess();
        }
        if (access == null && !this.warned) {
            this.warned = true;
            new NullPointerException("Cannot get registry access!").printStackTrace();
            InternalLogger.getInstance().warn("Cannot get registry access!");
            return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        }
        return access;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RegistryAccess getFromClient() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.registryAccess();
        }
        if (Minecraft.getInstance().getConnection() != null) {
            return Minecraft.getInstance().getConnection().registryAccess();
        }
        if (Minecraft.getInstance().gameMode != null) {
            return Minecraft.getInstance().gameMode.connection.registryAccess();
        }
        return null;
    }
}

