/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

public class VanillaWrappedWidget
extends Widget {
    private GuiEventListener element;

    public VanillaWrappedWidget(GuiEventListener element) {
        this.element = Objects.requireNonNull(element);
        this.setFocused(element);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        GuiEventListener guiEventListener = this.element;
        if (guiEventListener instanceof Widget) {
            Widget widget = (Widget)guiEventListener;
            widget.render(graphics, mouseX, mouseY, delta);
        } else {
            graphics.pose().pushPose();
            GuiEventListener guiEventListener2 = this.element;
            if (guiEventListener2 instanceof Renderable) {
                Renderable widget = (Renderable)guiEventListener2;
                widget.render(graphics, mouseX, mouseY, delta);
            }
            graphics.pose().popPose();
        }
    }

    public List<? extends GuiEventListener> children() {
        return Collections.singletonList(this.element);
    }

    @Override
    @Nullable
    public GuiEventListener getFocused() {
        return this.element;
    }

    @Override
    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener == this.element) {
            super.setFocused(this.element);
        } else {
            GuiEventListener guiEventListener2 = this.element;
            if (guiEventListener2 instanceof ContainerEventHandler) {
                ContainerEventHandler handler = (ContainerEventHandler)guiEventListener2;
                handler.setFocused(guiEventListener);
            }
        }
    }

    @Override
    public boolean isDragging() {
        return true;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.element.isMouseOver(mouseX, mouseY);
    }
}

