/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.ItemCheatingMode;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public abstract class DisplayedEntryWidget
extends EntryWidget {
    public int backupY;

    protected DisplayedEntryWidget(Point point, int entrySize) {
        super(point);
        this.backupY = point.y;
        this.getBounds().width = this.getBounds().height = entrySize;
    }

    @Override
    protected void drawHighlighted(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (!this.getCurrentEntry().isEmpty()) {
            super.drawHighlighted(graphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void queueTooltip(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (ClientHelper.getInstance().isCheating() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && !this.minecraft.player.containerMenu.getCarried().isEmpty()) {
            return;
        }
        super.queueTooltip(graphics, mouseX, mouseY, delta);
    }

    @Override
    protected boolean doAction(double mouseX, double mouseY, int button) {
        EntryStack<?> entry;
        if (ClientHelper.getInstance().isCheating() && !Screen.hasControlDown() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
            if (entry.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = entry.cheatsAs();
                EntryStack<Object> entryStack = entry = cheatsAs.isEmpty() ? entry : cheatsAs;
            }
            if (entry.getValueType() == ItemStack.class) {
                boolean all = ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.REI_LIKE ? button == 1 || Screen.hasShiftDown() : button != 1 || Screen.hasShiftDown();
                ((ItemStack)entry.castValue()).setCount(!all ? 1 : ((ItemStack)entry.castValue()).getMaxStackSize());
            }
            return ClientHelper.getInstance().tryCheatingEntry(entry);
        }
        return super.doAction(mouseX, mouseY, button);
    }

    @Override
    public boolean cancelDeleteItems(EntryStack<?> stack) {
        EntryStack<?> entry;
        if (!this.interactable || !ConfigObject.getInstance().isGrabbingItems()) {
            return super.cancelDeleteItems(stack);
        }
        if (ClientHelper.getInstance().isCheating() && !Screen.hasControlDown() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
            if (entry.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = entry.cheatsAs();
                entry = cheatsAs.isEmpty() ? entry : cheatsAs;
            }
            return EntryStacks.equalsExact(entry, stack);
        }
        return super.cancelDeleteItems(stack);
    }

    @Override
    public boolean keyPressedIgnoreContains(int keyCode, int scanCode, int modifiers) {
        EntryStack<?> entry;
        if (ClientHelper.getInstance().isCheating() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
            if (entry.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = entry.cheatsAs();
                EntryStack<Object> entryStack = entry = cheatsAs.isEmpty() ? entry : cheatsAs;
            }
            if (entry.getValueType() == ItemStack.class) {
                ((ItemStack)entry.castValue()).setCount(((ItemStack)entry.castValue()).getMaxStackSize());
                KeyMapping[] keyHotbarSlots = Minecraft.getInstance().options.keyHotbarSlots;
                for (int i = 0; i < keyHotbarSlots.length; ++i) {
                    if (!keyHotbarSlots[i].matches(keyCode, scanCode)) continue;
                    return ClientHelper.getInstance().tryCheatingEntryTo(entry, i);
                }
            }
        }
        return super.keyPressedIgnoreContains(keyCode, scanCode, modifiers);
    }
}

