/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class RecipeFinder {
    public final Int2IntMap idToAmountMap = new Int2IntOpenHashMap();

    public static int getItemId(ItemStack stack) {
        return StackedContents.getStackingIndex((ItemStack)stack);
    }

    public static ItemStack getStackFromId(int itemId) {
        return StackedContents.fromStackingIndex((int)itemId);
    }

    public void addNormalItem(ItemStack stack) {
        if (!(stack.isDamaged() || stack.isEnchanted() || stack.has(DataComponents.CUSTOM_NAME))) {
            this.addItem(stack);
        }
    }

    public void addItem(ItemStack stack) {
        this.addItem(stack, 64);
    }

    public void addItem(ItemStack stack, int count) {
        if (!stack.isEmpty()) {
            int itemId = RecipeFinder.getItemId(stack);
            int itemCount = Math.min(count, stack.getCount());
            this.addItem(itemId, itemCount);
        }
    }

    public boolean contains(int itemId) {
        return this.idToAmountMap.get(itemId) > 0;
    }

    public int take(int itemId, int amount) {
        int mapAmount = this.idToAmountMap.get(itemId);
        if (mapAmount >= amount) {
            this.idToAmountMap.put(itemId, mapAmount - amount);
            return itemId;
        }
        return 0;
    }

    private void addItem(int itemId, int itemCount) {
        this.idToAmountMap.put(itemId, this.idToAmountMap.get(itemId) + itemCount);
    }

    public boolean findRecipe(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1) {
        return this.findRecipe(ingredients, intList_1, 1);
    }

    public boolean findRecipe(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1, int maxCrafts) {
        return new Filter(ingredients).find(maxCrafts, intList_1);
    }

    public int countRecipeCrafts(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1) {
        return this.countRecipeCrafts(ingredients, Integer.MAX_VALUE, intList_1);
    }

    public int countRecipeCrafts(NonNullList<Ingredient> ingredients, int maxCrafts, @Nullable IntList intList_1) {
        return new Filter(ingredients).countCrafts(maxCrafts, intList_1);
    }

    public void clear() {
        this.idToAmountMap.clear();
    }

    class Filter {
        private final List<Ingredient> ingredients = Lists.newArrayList();
        private final int ingredientCount;
        private final int[] usableIngredientItemIds;
        private final int usableIngredientSize;
        private final BitSet bitSet;
        private final IntList path = new IntArrayList();
        private final NonNullList<Ingredient> ingredientsInput;

        public Filter(NonNullList<Ingredient> ingredientsInput) {
            this.ingredientsInput = ingredientsInput;
            this.ingredients.addAll(new ArrayList<Ingredient>((Collection<Ingredient>)ingredientsInput));
            this.ingredients.removeIf(Ingredient::isEmpty);
            this.ingredientCount = this.ingredients.size();
            this.usableIngredientItemIds = this.getUsableIngredientItemIds();
            this.usableIngredientSize = this.usableIngredientItemIds.length;
            this.bitSet = new BitSet(this.ingredientCount + this.usableIngredientSize + this.ingredientCount + this.ingredientCount * this.usableIngredientSize);
            for (int ingredientIndex = 0; ingredientIndex < this.ingredients.size(); ++ingredientIndex) {
                IntList possibleStacks = this.ingredients.get(ingredientIndex).getStackingIds();
                for (int usableIngredientIndex = 0; usableIngredientIndex < this.usableIngredientSize; ++usableIngredientIndex) {
                    if (!possibleStacks.contains(this.usableIngredientItemIds[usableIngredientIndex])) continue;
                    this.bitSet.set(this.getIndex(true, usableIngredientIndex, ingredientIndex));
                }
            }
        }

        public boolean find(int maxCrafts, @Nullable IntList intList_1) {
            boolean boolean_2;
            if (maxCrafts <= 0) {
                return true;
            }
            int int_2 = 0;
            while (this.dfs(maxCrafts)) {
                RecipeFinder.this.take(this.usableIngredientItemIds[this.path.getInt(0)], maxCrafts);
                int int_3 = this.path.size() - 1;
                this.setSatisfied(this.path.getInt(int_3));
                for (int int_4 = 0; int_4 < int_3; ++int_4) {
                    this.toggleResidual((int_4 & 1) == 0, this.path.get(int_4), this.path.get(int_4 + 1));
                }
                this.path.clear();
                this.bitSet.clear(0, this.ingredientCount + this.usableIngredientSize);
                ++int_2;
            }
            boolean boolean_1 = int_2 == this.ingredientCount;
            boolean bl = boolean_2 = boolean_1 && intList_1 != null;
            if (boolean_2) {
                intList_1.clear();
            }
            this.bitSet.clear(0, this.ingredientCount + this.usableIngredientSize + this.ingredientCount);
            int int_5 = 0;
            ArrayList<Ingredient> list_1 = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredientsInput);
            for (Ingredient ingredient : list_1) {
                if (boolean_2 && ingredient.isEmpty()) {
                    intList_1.add(0);
                    continue;
                }
                for (int int_7 = 0; int_7 < this.usableIngredientSize; ++int_7) {
                    if (!this.hasResidual(false, int_5, int_7)) continue;
                    this.toggleResidual(true, int_7, int_5);
                    RecipeFinder.this.addItem(this.usableIngredientItemIds[int_7], maxCrafts);
                    if (!boolean_2) continue;
                    intList_1.add(this.usableIngredientItemIds[int_7]);
                }
                ++int_5;
            }
            return boolean_1;
        }

        private int[] getUsableIngredientItemIds() {
            IntAVLTreeSet intCollection_1 = new IntAVLTreeSet();
            for (Ingredient ingredient_1 : this.ingredients) {
                intCollection_1.addAll((IntCollection)ingredient_1.getStackingIds());
            }
            IntIterator intIterator_1 = intCollection_1.iterator();
            while (intIterator_1.hasNext()) {
                if (RecipeFinder.this.contains(intIterator_1.nextInt())) continue;
                intIterator_1.remove();
            }
            return intCollection_1.toIntArray();
        }

        private boolean dfs(int amount) {
            int usableIngredientSize = this.usableIngredientSize;
            for (int int_3 = 0; int_3 < usableIngredientSize; ++int_3) {
                if (RecipeFinder.this.idToAmountMap.get(this.usableIngredientItemIds[int_3]) < amount) continue;
                this.visit(false, int_3);
                while (!this.path.isEmpty()) {
                    int int_8;
                    int int_4 = this.path.size();
                    boolean boolean_1 = (int_4 & 1) == 1;
                    int int_5 = this.path.getInt(int_4 - 1);
                    if (!boolean_1 && !this.isSatisfied(int_5)) break;
                    int int_6 = boolean_1 ? this.ingredientCount : usableIngredientSize;
                    for (int_8 = 0; int_8 < int_6; ++int_8) {
                        if (this.hasVisited(boolean_1, int_8) || !this.hasConnection(boolean_1, int_5, int_8) || !this.hasResidual(boolean_1, int_5, int_8)) continue;
                        this.visit(boolean_1, int_8);
                        break;
                    }
                    if ((int_8 = this.path.size()) != int_4) continue;
                    this.path.removeInt(int_8 - 1);
                }
                if (this.path.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean isSatisfied(int int_1) {
            return this.bitSet.get(this.getSatisfiedIndex(int_1));
        }

        private void setSatisfied(int int_1) {
            this.bitSet.set(this.getSatisfiedIndex(int_1));
        }

        private int getSatisfiedIndex(int int_1) {
            return this.ingredientCount + this.usableIngredientSize + int_1;
        }

        private boolean hasConnection(boolean boolean_1, int int_1, int int_2) {
            return this.bitSet.get(this.getIndex(boolean_1, int_1, int_2));
        }

        private boolean hasResidual(boolean boolean_1, int int_1, int int_2) {
            return boolean_1 != this.bitSet.get(1 + this.getIndex(boolean_1, int_1, int_2));
        }

        private void toggleResidual(boolean boolean_1, int int_1, int int_2) {
            this.bitSet.flip(1 + this.getIndex(boolean_1, int_1, int_2));
        }

        private int getIndex(boolean boolean_1, int int_1, int int_2) {
            int int_3 = boolean_1 ? int_1 * this.ingredientCount + int_2 : int_2 * this.ingredientCount + int_1;
            return this.ingredientCount + this.usableIngredientSize + this.ingredientCount + 2 * int_3;
        }

        private void visit(boolean boolean_1, int int_1) {
            this.bitSet.set(this.getVisitedIndex(boolean_1, int_1));
            this.path.add(int_1);
        }

        private boolean hasVisited(boolean boolean_1, int int_1) {
            return this.bitSet.get(this.getVisitedIndex(boolean_1, int_1));
        }

        private int getVisitedIndex(boolean boolean_1, int int_1) {
            return (boolean_1 ? 0 : this.ingredientCount) + int_1;
        }

        public int countCrafts(int maxCrafts, @Nullable IntList intList_1) {
            int int_2 = 0;
            int crafts = Math.min(maxCrafts, this.getMinIngredientCount()) + 1;
            while (true) {
                int int_4;
                if (this.find(int_4 = (int_2 + crafts) / 2, null)) {
                    if (crafts - int_2 <= 1) {
                        if (int_4 > 0) {
                            this.find(int_4, intList_1);
                        }
                        return int_4;
                    }
                    int_2 = int_4;
                    continue;
                }
                crafts = int_4;
            }
        }

        private int getMinIngredientCount() {
            int min = Integer.MAX_VALUE;
            for (Ingredient ingredient : this.ingredients) {
                int maxIngredientCount = 0;
                IntListIterator stackingIds = ingredient.getStackingIds().iterator();
                while (stackingIds.hasNext()) {
                    int currStackingId = stackingIds.next();
                    maxIngredientCount = Math.max(maxIngredientCount, RecipeFinder.this.idToAmountMap.get(currStackingId));
                }
                if (min <= 0) continue;
                min = Math.min(min, maxIngredientCount);
            }
            return min;
        }
    }
}

