/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.entry;

import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface EntryRegistry
extends Reloadable<REIClientPlugin> {
    public static EntryRegistry getInstance() {
        return PluginManager.getClientInstance().get(EntryRegistry.class);
    }

    public int size();

    public Stream<EntryStack<?>> getEntryStacks();

    public List<EntryStack<?>> getPreFilteredList();

    public void refilter();

    @Deprecated(forRemoval=true)
    public List<ItemStack> appendStacksForItem(Item var1);

    default public void addEntry(EntryStack<?> stack) {
        this.addEntryAfter(null, stack);
    }

    public void addEntryAfter(@Nullable EntryStack<?> var1, EntryStack<?> var2);

    default public void addEntriesAfter(@Nullable EntryStack<?> afterStack, EntryStack<?> ... stacks) {
        this.addEntriesAfter(afterStack, Arrays.asList(stacks));
    }

    public void addEntriesAfter(@Nullable EntryStack<?> var1, Collection<? extends EntryStack<?>> var2);

    default public void addEntries(EntryStack<?> ... stacks) {
        this.addEntries(Arrays.asList(stacks));
    }

    default public void addEntries(Collection<? extends EntryStack<?>> stacks) {
        this.addEntriesAfter(null, stacks);
    }

    @ApiStatus.Internal
    public Collection<EntryStack<?>> refilterNew(boolean var1, Collection<EntryStack<?>> var2);

    public boolean alreadyContain(EntryStack<?> var1);

    public boolean removeEntry(EntryStack<?> var1);

    public boolean removeEntryIf(Predicate<? extends EntryStack<?>> var1);

    public boolean removeEntryExactHashIf(LongPredicate var1);

    public boolean removeEntryFuzzyHashIf(LongPredicate var1);

    public boolean isReloading();

    @ApiStatus.Experimental
    public <Cache> void markFilteringRuleDirty(FilteringRule<Cache> var1, Collection<EntryStack<?>> var2, @Nullable LongCollection var3);
}

