/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.languagereload.core.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.hiedacamellia.languagereload.core.access.ILanguage;
import org.hiedacamellia.languagereload.core.access.ITranslationStorage;
import org.hiedacamellia.languagereload.core.config.ClientConfig;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={SessionSearchTrees.class}, priority=990)
abstract class SearchManagerMixin {
    SearchManagerMixin() {
    }

    @WrapOperation(method={"lambda$getTooltipLines$0(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/item/TooltipFlag;Lnet/minecraft/world/item/ItemStack;)Ljava/util/stream/Stream;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;")})
    private static List<Component> addFallbackTranslationsToSearchTooltips(ItemStack instance, Item.TooltipContext context, @Nullable Player player, TooltipFlag type, Operation<List<Component>> operation) {
        List original = (List)operation.call(new Object[]{instance, context, player, type});
        if (!ClientConfig.multilingualItemSearch) {
            return original;
        }
        Language language = Language.getInstance();
        if (language == null) {
            return original;
        }
        ClientLanguage translationStorage = ((ILanguage)language).languagereload_getTranslationStorage();
        if (translationStorage == null) {
            return original;
        }
        ArrayList<Component> result = new ArrayList<Component>(original);
        for (String fallbackCode : ClientConfig.fallbacks) {
            ((ITranslationStorage)translationStorage).languagereload_setTargetLanguage(fallbackCode);
            ((List)operation.call(new Object[]{instance, context, player, type})).stream().map(Component::getString).map(Component::literal).forEach(result::add);
        }
        ((ITranslationStorage)translationStorage).languagereload_setTargetLanguage(null);
        return result;
    }
}

