/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.languagereload.core.mixin;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Options;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import org.hiedacamellia.languagereload.LanguageReload;
import org.hiedacamellia.languagereload.client.gui.LanguageEntry;
import org.hiedacamellia.languagereload.client.gui.LanguageListWidget;
import org.hiedacamellia.languagereload.core.access.ILanguageOptionsScreen;
import org.hiedacamellia.languagereload.core.config.ClientConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageSelectScreen.class})
public abstract class LanguageOptionsScreenMixin
extends OptionsSubScreen
implements ILanguageOptionsScreen {
    @Unique
    private LanguageListWidget availableLanguageList;
    @Unique
    private LanguageListWidget selectedLanguageList;
    @Unique
    private EditBox searchBox;
    @Unique
    private final LinkedList<String> selectedLanguages = new LinkedList();
    @Unique
    private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<String, LanguageEntry>();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(Screen parent, Options options, LanguageManager languageManager, CallbackInfo ci) {
        String currentLangCode = languageManager.getSelected();
        if (!currentLangCode.equals("*")) {
            this.selectedLanguages.add(currentLangCode);
        }
        this.selectedLanguages.addAll(ClientConfig.fallbacks);
        languageManager.getLanguages().forEach((code, language) -> this.languageEntries.put((String)code, new LanguageEntry(this::refresh, (String)code, (LanguageInfo)language, this.selectedLanguages)));
        this.layout.setHeaderHeight(48);
        this.layout.setFooterHeight(53);
    }

    @Inject(method={"addContents"}, at={@At(value="HEAD")}, cancellable=true)
    void onInitBody(CallbackInfo ci) {
        int listWidth = Math.min(this.width / 2 - 4, 200);
        this.availableLanguageList = new LanguageListWidget(this.minecraft, this.it(), listWidth, this.height, (Component)Component.translatable((String)"pack.available.title"));
        this.selectedLanguageList = new LanguageListWidget(this.minecraft, this.it(), listWidth, this.height, (Component)Component.translatable((String)"pack.selected.title"));
        this.availableLanguageList.setX(this.width / 2 - 4 - listWidth);
        this.selectedLanguageList.setX(this.width / 2 + 4);
        this.layout.addToContents((LayoutElement)this.availableLanguageList);
        this.layout.addToContents((LayoutElement)this.selectedLanguageList);
        this.refresh();
        ci.cancel();
    }

    protected void addTitle() {
        this.searchBox = new EditBox(this.minecraft.font, this.width / 2 - 100, 22, 200, 20, this.searchBox, (Component)Component.empty()){

            public void setFocused(boolean focused) {
                if (!this.isFocused() && focused) {
                    super.setFocused(true);
                    LanguageOptionsScreenMixin.this.focusSearch();
                } else {
                    super.setFocused(focused);
                }
            }
        };
        this.searchBox.setResponder(__ -> this.refresh());
        LinearLayout header = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(5));
        header.defaultCellSetting().alignHorizontallyCenter();
        header.addChild((LayoutElement)new StringWidget(this.title, this.minecraft.font));
        header.addChild((LayoutElement)this.searchBox);
    }

    @Inject(method={"repositionElements"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onInitTabNavigation(CallbackInfo ci) {
        super.repositionElements();
        int listWidth = Math.min(this.width / 2 - 4, 200);
        this.availableLanguageList.updateSize(listWidth, this.layout);
        this.selectedLanguageList.updateSize(listWidth, this.layout);
        this.availableLanguageList.setX(this.width / 2 - 4 - listWidth);
        this.selectedLanguageList.setX(this.width / 2 + 4);
        this.availableLanguageList.updateScroll();
        this.selectedLanguageList.updateScroll();
        ci.cancel();
    }

    @Inject(method={"onDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDone(CallbackInfo ci) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen(this.lastScreen);
        String language = this.selectedLanguages.peekFirst();
        if (language == null) {
            LanguageReload.setLanguage("*", new LinkedList<String>());
        } else {
            LinkedList<String> fallbacks = new LinkedList<String>(this.selectedLanguages);
            fallbacks.removeFirst();
            LanguageReload.setLanguage(language, fallbacks);
        }
        ci.cancel();
    }

    @Unique
    private void refresh() {
        this.refreshList(this.selectedLanguageList, this.selectedLanguages.stream().map(this.languageEntries::get).filter(Objects::nonNull));
        this.refreshList(this.availableLanguageList, this.languageEntries.values().stream().filter(entry -> {
            if (this.selectedLanguageList.children().contains(entry)) {
                return false;
            }
            String query = this.searchBox.getValue().toLowerCase(Locale.ROOT);
            String langCode = entry.getCode().toLowerCase(Locale.ROOT);
            String langName = entry.getLanguage().toComponent().getString().toLowerCase(Locale.ROOT);
            return langCode.contains(query) || langName.contains(query);
        }));
    }

    @Unique
    private void refreshList(LanguageListWidget list, Stream<? extends LanguageEntry> entries) {
        LanguageEntry selectedEntry = (LanguageEntry)list.getSelected();
        list.setSelected(null);
        list.children().clear();
        entries.forEach(entry -> {
            list.children().add(entry);
            entry.setParent(list);
            if (entry == selectedEntry) {
                list.setSelected((AbstractSelectionList.Entry)entry);
            }
        });
        list.updateScroll();
    }

    protected void setInitialFocus() {
        this.focusSearch();
    }

    @Unique
    private void focusSearch() {
        this.changeFocus(ComponentPath.path((GuiEventListener)this.searchBox, (ContainerEventHandler[])new ContainerEventHandler[]{this}));
    }

    @Override
    public void languagereload_focusList(LanguageListWidget list) {
        this.changeFocus(ComponentPath.path((GuiEventListener)list, (ContainerEventHandler[])new ContainerEventHandler[]{this}));
    }

    @Override
    public void languagereload_focusEntry(LanguageEntry entry) {
        this.changeFocus(ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{entry.getParent(), this}));
    }

    @Unique
    LanguageSelectScreen it() {
        return (LanguageSelectScreen)this;
    }

    LanguageOptionsScreenMixin(Screen parent, Options options, Component title) {
        super(parent, options, title);
    }
}

