/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.languagereload;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiedacamellia.languagereload.core.access.IAdvancementsScreen;
import org.hiedacamellia.languagereload.core.config.ClientConfig;
import org.hiedacamellia.languagereload.core.mixin.BookScreenAccessor;
import org.hiedacamellia.languagereload.core.mixin.ClientChunkManagerAccessor;
import org.hiedacamellia.languagereload.core.mixin.ClientChunkMapAccessor;
import org.hiedacamellia.languagereload.core.mixin.SignTextAccessor;
import org.hiedacamellia.languagereload.core.mixin.TextDisplayEntityAccessor;

@Mod(value="languagereload")
public class LanguageReload {
    public static final String MODID = "languagereload";
    public static final Logger LOGGER = LogManager.getLogger((String)"languagereload");
    public static boolean shouldSetSystemLanguage = false;
    public static final String NO_LANGUAGE = "*";

    public LanguageReload(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        if (FMLLoader.getDist().isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    public static void reloadLanguages() {
        Minecraft client = Minecraft.getInstance();
        client.getLanguageManager().onResourceManagerReload(client.getResourceManager());
        client.updateTitle();
        client.gui.getChat().rescaleChat();
        Screen screen = client.screen;
        if (screen instanceof BookViewScreen) {
            BookViewScreen bookScreen = (BookViewScreen)screen;
            ((BookScreenAccessor)bookScreen).languagereload_setCachedPageIndex(-1);
        } else {
            screen = client.screen;
            if (screen instanceof AdvancementsScreen) {
                AdvancementsScreen advancementsScreen = (AdvancementsScreen)screen;
                ((IAdvancementsScreen)advancementsScreen).languagereload_recreateWidgets();
            }
        }
        if (client.level != null) {
            ClientChunkManagerAccessor chunkManager = (ClientChunkManagerAccessor)client.level.getChunkSource();
            AtomicReferenceArray<LevelChunk> chunks = ((ClientChunkMapAccessor)chunkManager.languagereload_getChunks()).languagereload_getChunks();
            for (int i = 0; i < chunks.length(); ++i) {
                LevelChunk chunk = chunks.get(i);
                if (chunk == null) continue;
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    if (!(blockEntity instanceof SignBlockEntity)) continue;
                    SignBlockEntity sign = (SignBlockEntity)blockEntity;
                    ((SignTextAccessor)sign.getFrontText()).languagereload_setOrderedMessages(null);
                    ((SignTextAccessor)sign.getBackText()).languagereload_setOrderedMessages(null);
                }
            }
            for (Entity entity : client.level.entitiesForRendering()) {
                if (!(entity instanceof Display.TextDisplay)) continue;
                Display.TextDisplay textDisplay = (Display.TextDisplay)entity;
                ((TextDisplayEntityAccessor)textDisplay).languagereload_setTextLines(null);
            }
        }
    }

    public static void setLanguage(String language, LinkedList<String> fallbacks) {
        Minecraft client = Minecraft.getInstance();
        LanguageManager languageManager = client.getLanguageManager();
        if (!ClientConfig.SPEC.isLoaded()) {
            return;
        }
        boolean languageIsSame = languageManager.getSelected().equals(language);
        boolean fallbacksAreSame = ClientConfig.fallbacks.equals(fallbacks);
        if (languageIsSame && fallbacksAreSame) {
            return;
        }
        ClientConfig.PREVIOUS_LANGUAGE.set((Object)languageManager.getSelected());
        ClientConfig.PREVIOUS_FALLBACKS.set(ClientConfig.fallbacks);
        ClientConfig.LANGUAGE.set((Object)language);
        ClientConfig.FALLBACKS.set(fallbacks);
        ClientConfig.SPEC.save();
        languageManager.setSelected(language);
        client.options.languageCode = language;
        client.options.save();
        ClientConfig.load();
        LanguageReload.reloadLanguages();
    }
}

