/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.MegaBraceletItem;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class MegaLogic {
    public static void EvoLogic(Player playerContext) {
        ServerPlayer player = (ServerPlayer)playerContext;
        if (Config.battleModeOnly) {
            return;
        }
        boolean hasMegaItem = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.getItem() instanceof MegaBraceletItem)).orElse(false);
        if (!hasMegaItem || player.getOffhandItem().getItem() instanceof MegaBraceletItem || player.getMainHandItem().getItem() instanceof MegaBraceletItem) {
            return;
        }
        double range = 5.0;
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = startPos.add(lookVec.multiply(range, range, range));
        AABB searchBox = new AABB(startPos, endPos).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)searchBox, entity -> !entity.isSpectator() && entity.isPickable(), (float)0.3f);
        if (entityHit == null) {
            return;
        }
        Entity entity2 = entityHit.getEntity();
        if (entity2 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity2;
            if (pk.level().isClientSide) {
                return;
            }
            List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
            boolean end = false;
            for (String key : megaKeys) {
                FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                FlagSpeciesFeature feature = featureProvider.get(pk.getPokemon());
                if (feature == null) continue;
                boolean enabled = featureProvider.get(pk.getPokemon()).getEnabled();
                if (enabled) {
                    MegaLogic.Devolve((LivingEntity)pk, (Player)player);
                    end = false;
                    break;
                }
                end = true;
            }
            if (end) {
                MegaLogic.Evolve((LivingEntity)pk, (Player)player);
            }
        }
    }

    public static void Evolve(LivingEntity context, Player player) {
        PokemonEntity pk;
        PokemonEntity pk2;
        if (context instanceof PokemonEntity && (pk2 = (PokemonEntity)context).getPokemon().getOwnerPlayer() != player) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)context).getPokemon();
        Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                player.setData(DataManage.MEGA_DATA, (Object)true);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                found = true;
            }
            if (!found) {
                player.displayClientMessage((Component)Component.literal((String)"Rayquaza doesn't have dragonascent").withColor(0xFF0000), true);
            }
            return;
        }
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
            return;
        }
        if (species == null) {
            player.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
            return;
        }
        if (context instanceof PokemonEntity && (pk = (PokemonEntity)context).isBattling() && Config.battleMode) {
            player.displayClientMessage((Component)Component.literal((String)"Not allowed in battle").withColor(0xFF0000), true);
            return;
        }
        if (species.getName().equals(pokemon.getSpecies().getName()) && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            if (species.getName().equals(Utils.getSpecies("charizard").getName())) {
                if (pokemon.heldItem().is(ModItems.CHARIZARDITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                } else if (pokemon.heldItem().is(ModItems.CHARIZARDITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                }
            } else if (species.getName().equals(Utils.getSpecies("mewtwo").getName())) {
                if (pokemon.heldItem().is(ModItems.MEWTWONITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                } else if (pokemon.heldItem().is(ModItems.MEWTWONITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                }
            } else {
                player.setData(DataManage.MEGA_DATA, (Object)true);
                player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
            }
        } else if (species.getName().equals(pokemon.getSpecies().getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
        }
    }

    public static void Devolve(LivingEntity context, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        if (context instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)context;
            if (pk.getPokemon().getOwnerPlayer() != player) {
                return;
            }
            if (pk.isBattling() && Config.battleMode) {
                player.displayClientMessage((Component)Component.literal((String)"Not allowed in battle").withColor(0xFF0000), true);
                return;
            }
        }
        Pokemon pokemon = ((PokemonEntity)context).getPokemon();
        player.setData(DataManage.MEGA_DATA, (Object)false);
        player.setData(DataManage.MEGA_POKEMON, (Object)new Pokemon());
        new FlagSpeciesFeature("mega", false).apply(pokemon);
        new FlagSpeciesFeature("mega-x", false).apply(pokemon);
        new FlagSpeciesFeature("mega-y", false).apply(pokemon);
    }
}

