/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class MegaBraceletItem
extends Item {
    public MegaBraceletItem(Item.Properties arg) {
        super(arg);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity context, InteractionHand hand) {
        if (player.level().isClientSide) return InteractionResult.PASS;
        if (Config.battleModeOnly) {
            return InteractionResult.PASS;
        }
        if (Config.braceletHandSensitive) {
            if (hand == InteractionHand.MAIN_HAND && context instanceof PokemonEntity) {
                PokemonEntity pk = (PokemonEntity)context;
                if (!context.level().isClientSide()) {
                    List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                    boolean end = false;
                    for (String key : megaKeys) {
                        boolean enabled;
                        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                        FlagSpeciesFeature feature = featureProvider.get(pk.getPokemon());
                        if (feature == null || !(enabled = featureProvider.get(pk.getPokemon()).getEnabled())) continue;
                        end = true;
                        break;
                    }
                    if (end) return InteractionResult.PASS;
                    MegaLogic.Evolve(context, player);
                    return InteractionResult.PASS;
                }
            }
            if (hand != InteractionHand.OFF_HAND) return InteractionResult.PASS;
            if (!(context instanceof PokemonEntity)) return InteractionResult.PASS;
            if (context.level().isClientSide()) return InteractionResult.PASS;
            MegaLogic.Devolve(context, player);
            return InteractionResult.PASS;
        }
        if (Config.braceletHandSensitive) return InteractionResult.PASS;
        if (!(context instanceof PokemonEntity)) return InteractionResult.PASS;
        PokemonEntity pk = (PokemonEntity)context;
        Pokemon pokemon = pk.getPokemon();
        if (pokemon.getEntity() == null) return InteractionResult.PASS;
        if (pokemon.getEntity().level().isClientSide) {
            return InteractionResult.PASS;
        }
        List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
        boolean end = false;
        for (String key : megaKeys) {
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature == null) continue;
            boolean enabled = featureProvider.get(pokemon).getEnabled();
            if (enabled) {
                MegaLogic.Devolve(context, player);
                end = false;
                break;
            }
            end = true;
        }
        if (!end) return InteractionResult.PASS;
        MegaLogic.Evolve(context, player);
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> tooltipComponents, TooltipFlag arg3) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.mega_showdown.megabracelet.tooltip"));
        super.appendHoverText(arg, arg2, tooltipComponents, arg3);
    }
}

