/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class InputSlotCrafter<T extends AbstractContainerMenu, C extends Container> {
    protected T container;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    protected ServerPlayer player;

    protected InputSlotCrafter(T container) {
        this.container = container;
    }

    public void fillInputSlots(ServerPlayer player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.getInventorySlots();
        this.inputStacks = this.getInputSlots();
        this.cleanInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.populateRecipeFinder(recipeFinder);
        NonNullList ingredients = NonNullList.create();
        for (InputIngredient<ItemStack> itemStacks : this.getInputs()) {
            ingredients.add((Object)CollectionUtils.toIngredient(itemStacks.get()));
        }
        if (!recipeFinder.findRecipe((NonNullList<Ingredient>)ingredients, null)) {
            this.cleanInputs();
            this.markDirty();
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (NonNullList<Ingredient>)ingredients, hasShift);
        this.markDirty();
    }

    protected abstract Iterable<SlotAccessor> getInputSlots();

    protected abstract Iterable<SlotAccessor> getInventorySlots();

    protected abstract List<InputIngredient<ItemStack>> getInputs();

    protected abstract void populateRecipeFinder(RecipeFinder var1);

    protected abstract void markDirty();

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<Integer> recipeItemIds, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItemIds.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItemIds.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(Integer recipeItemId, SlotAccessor inputStack, int craftsAmount) {
        ItemStack toBeTakenStack = RecipeFinder.getStackFromId(recipeItemId);
        if (!toBeTakenStack.isEmpty()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, ItemStack toBeTakenStack) {
        ItemStack takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().copy()).isEmpty()) {
            if (takenStack.getCount() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(ItemStack.EMPTY);
            }
            takenStack.setCount(1);
            if (!slot.canPlace(takenStack)) {
                return;
            }
            if (slot.getItemStack().isEmpty()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().grow(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, NonNullList<Ingredient> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        IntArrayList recipeItemIds = new IntArrayList();
        int amountToFill = hasShift ? recipeCrafts : 1;
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = recipeItemIds.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).getMaxStackSize());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, finalCraftsAmount)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, (Iterator<Integer>)recipeItemIds.iterator(), finalCraftsAmount);
            }
        }
    }

    protected abstract void cleanInputs();

    @Nullable
    public SlotAccessor takeInventoryStack(ItemStack itemStack) {
        boolean rejectedModification = false;
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            ItemStack itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.isEmpty() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.isDamaged() || itemStack1.isEnchanted() || itemStack1.has(DataComponents.CUSTOM_NAME)) continue;
            if (!inventoryStack.allowModification((Player)this.player)) {
                rejectedModification = true;
                continue;
            }
            return inventoryStack;
        }
        if (rejectedModification) {
            throw new IllegalStateException("Unable to take item from inventory due to slot not allowing modification! Item requested: " + String.valueOf(itemStack));
        }
        return null;
    }

    private static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

