/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class CollapsedEntriesTooltip
implements ClientTooltipComponent,
TooltipComponent {
    private static final int MAX_WIDTH = 140;
    private final CollapsedStack stack;

    public CollapsedEntriesTooltip(CollapsedStack stack) {
        this.stack = stack;
    }

    public int getHeight() {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 140 / entrySize);
        return Math.min(3, Mth.ceil((float)((float)this.stack.getIngredient().size() / (float)w))) * entrySize + 2;
    }

    public int getWidth(Font font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 140 / entrySize);
        int size = this.stack.getIngredient().size();
        return Math.min(size, w) * entrySize;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 140 / entrySize);
        int i = 0;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 50.0f);
        for (EntryStack<?> entry : this.stack.getIngredient()) {
            int x1 = x + i % w * entrySize;
            int y1 = y + i / w * entrySize;
            if (++i / w > 2) {
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                MutableComponent text = Component.literal((String)("+" + (this.stack.getIngredient().size() - w * 3 + 1))).withStyle(ChatFormatting.GRAY);
                font.drawInBatch((Component)text, (float)(x1 + entrySize / 2 - font.width((FormattedText)text) / 2), (float)(y1 + entrySize / 2 - 1), -1, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                graphics.flush();
                break;
            }
            entry.render(graphics, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0.0f);
        }
        graphics.pose().popPose();
    }
}

