/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import com.google.common.base.MoreObjects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public interface DraggingContext<S extends Screen> {
    public static DraggingContext<?> getInstance() {
        return REIRuntime.getInstance().getOverlay().get().getDraggingContext();
    }

    default public boolean isDraggingStack() {
        return this.getCurrentStack() != null;
    }

    default public boolean isDraggingComponent() {
        return this.getDragged() != null;
    }

    public S getScreen();

    @Nullable
    public DraggableStack getCurrentStack();

    @Nullable
    public DraggableComponent<?> getDragged();

    @Nullable
    public Point getCurrentPosition();

    @Nullable
    public Rectangle getCurrentBounds();

    default public void renderBackToPosition(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
        this.renderBack(stack, initialPosition, position);
    }

    default public void renderBackToPosition(DraggableStack stack, Rectangle initialPosition, Supplier<Rectangle> bounds) {
        this.renderBack(stack, initialPosition, bounds);
    }

    default public void renderToVoid(DraggableStack stack) {
        this.renderToVoid((DraggableComponent<?>)stack);
    }

    public void renderBack(DraggableComponent<?> var1, Point var2, Supplier<Point> var3);

    public void renderBack(DraggableComponent<?> var1, Rectangle var2, Supplier<Rectangle> var3);

    default public void renderToVoid(DraggableComponent<?> component) {
        Rectangle currentBounds = (Rectangle)MoreObjects.firstNonNull((Object)this.getCurrentBounds(), (Object)component.getOriginBounds(PointHelper.ofMouse()));
        Rectangle targetBounds = new Rectangle(currentBounds.getCenterX(), currentBounds.getCenterY(), 1, 1);
        int width = component.getWidth();
        int height = component.getHeight();
        this.renderBack(component, currentBounds, () -> targetBounds);
    }

    default public <T extends Screen> DraggingContext<T> cast() {
        return this;
    }
}

