/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.entry.filtering;

import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Experimental
public interface FilteringRuleType<T extends FilteringRule<?>> {
    public static CompoundTag save(FilteringRule<?> rule, CompoundTag tag) {
        tag.putString("id", rule.getType().getId().toString());
        tag.put("rule", (Tag)rule.getType().saveTo(rule, new CompoundTag()));
        return tag;
    }

    public CompoundTag saveTo(T var1, CompoundTag var2);

    @Nullable
    public static FilteringRule<?> read(CompoundTag tag) {
        FilteringRuleType<?> type = FilteringRuleTypeRegistry.getInstance().get(ResourceLocation.tryParse((String)tag.getString("id")));
        if (type == null) {
            return null;
        }
        return type.readFrom(tag.getCompound("rule"));
    }

    public T readFrom(CompoundTag var1);

    @Nullable
    default public Function<Screen, Screen> createEntryScreen(T rule) {
        return null;
    }

    default public Component getTitle(T rule) {
        return Component.nullToEmpty((String)this.getId().toString());
    }

    default public Component getSubtitle(T rule) {
        return Component.nullToEmpty(null);
    }

    default public ResourceLocation getId() {
        return Objects.requireNonNull(FilteringRuleTypeRegistry.getInstance().getId(this), "Id of " + String.valueOf(this));
    }

    public T createNew();

    public boolean isSingular();
}

